### Register Transforms
### This is interesting because we don't expect all transforms to be
### available on all platforms. To do this we allow things to fail at
### two levels
### 1) Imports
###    If the import fails the module is removed from the list and
###    will not be processed/registered
### 2) Registration
###    A second phase happens when the loaded modules register method
###    is called and this produces an instance that will used to
###    implement the transform, if register needs to fail for now it
###    should raise an ImportError as well (dumb, I know)

from Products.PortalTransforms.libtransforms.utils import MissingBinary
modules = [
    'st',             # zopish
    'rest',           # docutils
    'word_to_html',   # uno, com, wvware
    'html_to_text',   # re based transform
    'text_to_html',   # wrap text in a verbatim env
    'text_pre_to_html', # wrap text into a pre
    'pdf_to_html',    # sf.net/projects/pdftohtml
    'pdf_to_text',    # www.foolabs.com/xpdf
    'rtf_to_html',    # sf.net/projects/rtf-converter
    'rtf_to_xml',     # sf.net/projects/rtf2xml
    'lynx_dump',      # lynx -dump
    'python',         # python source files, no dependancies
    'identity',       # identity transform, no dependancies
    ]

g = globals()
transforms = []
for m in modules:
    try:
        ns = __import__(m, g, g, None)
        transforms.append(ns.register())
    except ImportError, e:
        print "Problem importing module %s : %s" % (m, e)
    except MissingBinary, e:
        print e
    except:
        import traceback
        traceback.print_exc()


def initialize(engine):
    for transform in transforms:
        engine.registerTransform(transform)
