##############################################################################
#
# Copyright (c) 2001, 2002 Zope Corporation and Contributors.
# All Rights Reserved.
# 
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
# 
##############################################################################
"""
Revision information:
$Id: PDFStylesheet.py,v 1.2 2002/04/04 01:31:29 chrism Exp $
"""
from reportlab.lib.enums import TA_CENTER, TA_LEFT
from reportlab.lib.styles import ParagraphStyle
from reportlab.lib.colors import white, black, green, grey, HexColor

Base = ParagraphStyle(
   name='Base',
   fontName='Helvetica',
   fontSize=10,
   leading=12,
   leftIndent=0,
   rightIndent=0,
   firstLineIndent=0,
   alignment=TA_LEFT,
   spaceBefore=0,
   spaceAfter=0,
   bulletFontName='Helvetica',
   bulletFontSize=10,
   bulletIndent=0,
   textColor=black,
   backColor=None
   )

STYLES = {
   'Normal':ParagraphStyle(
   name='Normal',
   fontName='Helvetica',
   fontSize=10,
   leading=12
   ),

   'BodyText':ParagraphStyle(
   name='BodyText',
   parent=Base,
   spaceBefore=4
   ),

   'H1':ParagraphStyle(
   name='Heading1',
   parent=Base,
   fontName = 'Helvetica-Bold',
   fontSize=18,
   leading=22,
   spaceAfter=4
   ),

   'H2':ParagraphStyle(
   name='Heading2',
   parent=Base,
   fontName = 'Helvetica-Bold',
   fontSize=14,
   leading=18,
   spaceBefore=4,
   spaceAfter=4
   ),
                   
   'H3':ParagraphStyle(
   name='Heading3',
   parent=Base,
   fontName = 'Helvetica-BoldOblique',
   fontSize=12,
   leading=14,
   spaceBefore=4,
   spaceAfter=4
   ),

   'H4':ParagraphStyle(
   name='Heading4',
   parent=Base,
   fontName = 'Helvetica-BoldOblique',
   fontSize=10,
   leading=14,
   spaceBefore=4,
   spaceAfter=4
   ),

   'Title':ParagraphStyle(
   name='Title',
   parent=Base,
   fontName = 'Helvetica-Bold',
   fontSize=18,
   leading=22,
   alignment=TA_CENTER,
   spaceAfter=4
   ),

   'Bullet':ParagraphStyle(
   name='Bullet',
   parent=Base,
   firstLineIndent=0,
   spaceBefore=3
   ),

   'Definition':ParagraphStyle(
   name='Definition',
   parent=Base,
   firstLineIndent=0,
   leftIndent=0,
   bulletIndent=0,
   spaceBefore=4,
   bulletFontName='Symbol'
   ),

   'Code':ParagraphStyle(
   name='Code',
   parent=Base,
   fontName='Courier',
   fontSize=8,
   leading=8.8,
   firstLineIndent=0,
   leftIndent=0
   ),

   'Caption':ParagraphStyle(
   name='Caption',
   parent=Base,
   fontName='Helvetica',
   fontSize=9,
   alignment=TA_CENTER,

   ),

  'Bullet1':ParagraphStyle(
    name='Bullet1',
    parent=Base,
    firstLineIndent=0,
    leftIndent=0,
    bulletIndent=-20,
    spaceBefore=6,
    bulletText='\267',
    bulletFontName='Symbol'
    ),

  'Bullet2':ParagraphStyle(
    name='Bullet2',
    parent=Base,
    firstLineIndent=0,
    leftIndent=12,
    bulletIndent=-8,
    spaceBefore=6,
    bulletText='\267',
    bulletFontName='Symbol'
    ),
   
  'Bullet3':ParagraphStyle(
    name='Bullet3',
    parent=Base,
    firstLineIndent=0,
    leftIndent=24,
    bulletIndent=4,
    spaceBefore=6,
    bulletText='\267',
    bulletFontName='Symbol'
    ),
   
  'Bullet4':ParagraphStyle(
    name='Bullet4',
    parent=Base,
    firstLineIndent=0,
    leftIndent=36,
    bulletIndent=16,
    spaceBefore=6,
    bulletText='\267',
    bulletFontName='Symbol'
    ),

   'Title':ParagraphStyle(
   name='Title',
   parent=Base,
   fontName = 'Helvetica-Bold',
   fontSize=24,
   leading=22,
   spaceBefore=4,
   spaceAfter=10,
   alignment=TA_CENTER
   ),

   'Author':ParagraphStyle(
   name='Author',
   parent=Base,
   fontName = 'Helvetica-Bold',
   fontSize=12,
   leading=22,
   spaceBefore=4,
   spaceAfter=4,
   alignment=TA_CENTER
   ),

   'CenteredBodyText':ParagraphStyle(
   name='CenteredBodyText',
   parent=Base,
   fontName = 'Helvetica',
   fontSize=10,
   leading=22,
   spaceBefore=4,
   spaceAfter=4,
   alignment=TA_CENTER
   ),

   'BoldCenteredBodyText':ParagraphStyle(
   name='BoldCenteredBodyText',
   parent=Base,
   fontName = 'Helvetica-Bold',
   fontSize=10,
   leading=22,
   spaceBefore=4,
   spaceAfter=4,
   alignment=TA_CENTER
   ),

   'Comment':ParagraphStyle(
   name='Comment',
   parent=Base,
   fontName = 'Times-Roman',
   fontSize=10,
   leading=12,
   spaceBefore=4,
   spaceAfter=4,
   alignment=TA_LEFT,
   textColor=green,
   backColor=HexColor('0xeeeeff'),
   ),
}

