from Products.CMFCore.utils import getToolByName
from Products.CMFPlone.migrations.migration_util import safeEditProperty
from Products.Archetypes import public as atapi
from Products.CMFMember.config import USE_SCHEMA_EDITOR
from Products.CMFMember.content.member_schema import *
from Products.CMFMember.content.member import BaseMember

def reconfigureUI(portal):
    """ Install cmfmember_portlet and change configlets.
    """
    out = []
    
    # sets up the slots on portal_memberdata
    left_slots=( 'here/portlet_cmfmember/macros/portlet'
               , 'here/portlet_cmfmember/macros/portlet_prefs_wrapper' )
    right_slots=( )
    safeEditProperty(portal.portal_memberdata, 'left_slots', left_slots, 'lines')
    safeEditProperty(portal.portal_memberdata, 'right_slots', right_slots, 'lines')
    out.append('Left & right slots set for portal_memberdata.')
    return out
    
def reconfigureUserManagementURL(portal):
    pass
    
def externalStorageHandling(portal):
    """ Move from one external storage to multiple. """
    out = []
    
    return out

def setFormControllerOverrides(portal):
    # Check to see if the choose_destination form controller action
    # is set and set it if not
    out = []
    fc = getToolByName(portal, 'portal_form_controller')
    action = fc.getAction('validate_integrity','success', 'Member', 'save')
    if action and action.getActionArg() == 'string:edit':
        out.append('Delegating the final edit destination to the ' + \
                   'choose_destination script')
        fc.actions.delete(action.key())
        fc.addFormAction('validate_integrity', 'success', 'Member', 'save',
                         'traverse_to', 'string:choose_destination')
    return out

def initializeSchemaEditor(portal):
    """ perform schema editor initializations for MemberDataContainer """
    out = []
    if USE_SCHEMA_EDITOR:
        mdc = getToolByName(portal, 'portal_memberdata')
        ctrl = getToolByName(portal, 'cmfmember_control')
        cp = getToolByName(portal, 'portal_controlpanel')
        klasses = ctrl.getMemberKlasses().values()
        for klass in klasses:
            mdc.atse_registerObject(klass, domain='plone')

        mdc.atse_setPostMacro('/here/atse_cmfmember/macros/post_macro',
                              'processSchemaEditor')

        out.append('Schema editor initialization complete')
    return out

def installConfiglets(portal):
    """ make sure all available configlets have been installed """
    out = []
    ctrl = getToolByName(portal, 'cmfmember_control')
    cp = getToolByName(portal, 'portal_controlpanel')
    configlets = ctrl.getConfiglets()
    old_cfg_ids = [cfg['id'] for cfg in cp.enumConfiglets('CMFMember')]
    for old_cfg_id in old_cfg_ids:
        cp.unregisterConfiglet(old_cfg_id)
    for cfg in configlets:
        if not cfg['id'] in old_cfg_ids:
            cp.unregisterConfiglet(cfg['id'])
        
    cp.registerConfiglets(configlets)
    out.append("Configlets registered")
    return out

def one0_one1b1(portal):
    """ upgrade from CMFMember 1.0 to CMFMember 1.1.
        Define your own methods and call them from here.
     """
    out = []
    
    out += reconfigureUI(portal)
    out += setFormControllerOverrides(portal)
    out += initializeSchemaEditor(portal)
    out += installConfiglets(portal)
    
    return out
