# -*- coding: ISO-8859-15 -*-
# (C) Copyright 2005 Nuxeo SARL <http://nuxeo.com>
# Author: Tarek Ziad <tz@nuxeo.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.
#
# $Id: __init__.py 17977 2005-03-15 13:57:04Z madarche $
from Products.CMFCore.utils import ContentInit
from Products.CMFCore.DirectoryView import registerDirectory
from Products.CMFCore.permissions import AddPortalContent
import wiki, wikipage

fti = (wiki.factory_type_information +
       wikipage.factory_type_information)

registerDirectory('www', globals())

contentClasses = (wiki.Wiki,
                  wikipage.WikiPage, )

contentConstructors = ( wiki.manage_addWiki,
                        wikipage.manage_addWikiPage, )

fti = (wiki.factory_type_information +
       wikipage.factory_type_information)


def initialize(context):
    ContentInit('Wiki Content',
                      content_types=contentClasses,
                      permission=AddPortalContent,
                      extra_constructors=contentConstructors,
                      fti=fti
                      ).initialize(context)
