# -*- coding: ISO-8859-15 -*-
# (C) Copyright 2005 Nuxeo SARL <http://nuxeo.com>
# Author: Tarek Ziad <tz@nuxeo.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.
#
# $Id: test_wwwparser.py 18046 2005-04-29 09:24:03Z tziade $
import unittest
#from Testing.ZopeTestCase.doctest import DocTestSuite
from Testing.ZopeTestCase import ZopeTestCase, _print
from Products.CPSWiki.wwwparser import WwwParser
from Products.CPSWiki.wiki import Wiki

class WikiParserTest(ZopeTestCase):


    def test_parsing(self):
        parser = WwwParser()
        res = parser.parseContent(None, "qzp '''strong''' ideee")
        self.assertEquals(res, ([], 'qzp <STRONG>strong</STRONG> ideee'))

    def test_parsing2(self):
        parser = WwwParser()
        res = parser.parseContent(None, 'qzpijdspjvd http://foo.bar vjpdsovj')
        self.assertEquals(res, ([],
        'qzpijdspjvd <a href="http://foo.bar">http://foo.bar</a> vjpdsovj'))

def test_suite():
    """
    return unittest.TestSuite((
        DocTestSuite('Products.CPSWiki.wiki'),
        unittest.makeSuite(Test),
        ))
    """
    return unittest.TestSuite((
        unittest.makeSuite(WikiParserTest),
        ))

if __name__ == '__main__':
    unittest.main(defaultTest='test_suite')