__doc__='''Notations object  implementation'''

__version__='$Revision: 1.1 $'[11:-2]

from Globals import Persistent, DateTime

import Persistence
PersistentMapping = Persistence.PersistentMapping

import string

class Notation( Persistent ):

    text = ''
    user = ''
    addTime = None
    
    def __init__(self, text, user, addTime = None):
        self.text = text
        self.user = user

        if addTime is None:
            addTime = DateTime('est')
            
        self.addTime = addTime

class Notations( Persistent ):

    def __init__(self):
        self.notes = PersistentMapping()
        self.keyNum = 1

    def addNotation(self, text, user, addTime = None):

        c = self.notes
        c[`self.keyNum`] = Notation(text, user, addTime)
        self.keyNum = self.keyNum + 1
        self.notes = c

    def __getitem__(self, key):
        return self.notes[key]

    def keys(self):
        return self.notes.keys()

    def __len__(self):
        return len(self.notes)

    def __setitem__(self, key, val):
        self.notes[key] = val

    def __delitem__(self, key):
        del self.notes[key]

    def has_key(self, key):
        return self.notes.has_key(key)

    def values(self):
        return self.notes.values()

    def items(self):
        return self.notes.items()

