__version__ = '$Revision: 1.13 $'[11:-2]

import traceback
from cStringIO import StringIO
from Acquisition import aq_base
from Products.CMFCore.utils import getToolByName
from Products.Archetypes.public import listTypes
from Products.Archetypes.Extensions.utils import installTypes, install_subskin
from Products.ExternalMethod.ExternalMethod import manage_addExternalMethod
from Products.PortalTransport import config
from Products.PortalTransport.config import *
from Products.PortalTransport.MailSpool import MailSpool
from Products.PortalTransport.MailTemplatesTool import MailTemplatesTool
from Products.PortalTransport.MailTransport import MailTransport
from Products.PortalTransport.SubscriptionEngine import SubscriptionEngine
from Products.PortalTransport.Workflows import si_workflow, si_workflow_id
from Products.PortalTransport.utils import install_mail_templates
from Products.PortalTransport.templates import templates

def install(self):
    out = StringIO()

    portal = getToolByName(self, 'portal_url').getPortalObject()

    if hasattr(portal, 'portal_quickinstaller'):
        portal.portal_quickinstaller.installProduct('Archetypes')

    installTypes(self, out, listTypes(PROJECTNAME), PROJECTNAME)
    install_subskin(self, out, GLOBALS)
    
    install_global_properties(self, out)
    install_tools(self, portal, out)
    install_skins(self, portal, out)
    install_actions(self, out)
    install_mail_templates(self, portal, templates, out)

    wtool = portal.portal_workflow
    wtool.setChainForPortalTypes(('PT_MailCategory',), '')
    wtool.setChainForPortalTypes(('PT_MailTemplate',), '')

    if si_workflow_id in wtool.objectIds():
        wtool._delObject(si_workflow_id)

    wtool.manage_addWorkflow(id=si_workflow_id, workflow_type=si_workflow)
    wtool.setChainForPortalTypes(('PT_SIMember',), si_workflow_id)
    wtool.setChainForPortalTypes(('PT_SIAnonymous',), si_workflow_id)
    
    print >> out, "Successfully installed %s." % PROJECTNAME
    return out.getvalue()

def install_tools(self, portal, out):
    # install mail transport tool
    if not hasattr(portal, 'portal_mailtransport'):
        portal.manage_addProduct[PROJECTNAME].manage_addTool(
            MailTransport.meta_type, None)
        print >> out, "Successfully installed MailTransport Tool."
            
    # install mail spool tool
    try:
        if MailSpool.meta_type != portal.portal_mailspool.meta_type:
            portal._delObject('portal_mailspool')
    except:
        pass
            
    if not hasattr(portal, 'portal_mailspool'):
        portal.manage_addProduct[PROJECTNAME].manage_addTool(
            MailSpool.meta_type, None)
        print >> out, "Successfully installed MailSpool Tool."

    # install mail templates tool
    try:
        if MailTemplatesTool.meta_type != portal.portal_mailtemplates.meta_type:
            portal._delObject('portal_mailtemplates')
    except:
        pass

    if not hasattr(portal, 'portal_mailtemplates'):
        try:
            portal.manage_addProduct[PROJECTNAME].manage_addTool(
                MailTemplatesTool.meta_type, None)
            print >> out, "Successfully installed MailTemplates Tool."
        except:
            print >> out, "Failed to install MailTemplates Tool."

    # install subscription tool
    if not hasattr(portal, 'portal_subscriptions'):
        try:
            portal.manage_addProduct[PROJECTNAME].manage_addTool(
                SubscriptionEngine.meta_type, None)
            print >> out, "Successfully installed Subscriptions Tool."
        except:
            traceback.print_exc()
            print >> out, "Failed to install Subscriptions Tool."


def uninstall(self):
    out = StringIO()

    # uninstall configs
    self.portal_controlpanel.unregisterApplication(PROJECTNAME)
        
    print >> out, "Successfully uninstalled %s." % PROJECTNAME
    return out.getvalue()


def install_actions(self, out):
    try:
        self.portal_controlpanel.registerConfiglet(**mailtransport_configlet)
        self.portal_controlpanel.registerConfiglet(**mailtemplates_configlet)
        #self.portal_controlpanel.registerConfiglet(**subscriptions_configlet)
    except:
        traceback.print_exc()


def install_global_properties(self, out):
    # install mailtransport properties
    if not hasattr(self.portal_properties, 'portaltransport_properties'):
        self.portal_properties.addPropertySheet(
            'portaltransport_properties', 'PortalTransport properties')
    props = self.portal_properties.portaltransport_properties
    for prop, tp, val in config.portaltransport_properties:
        if not props.hasProperty(prop):
            props._setProperty(prop, val, tp)

    print >> out, "Successfully installed global properties."


def install_skins(self, portal, out):
    dtool = portal.portal_discussion
    skinstool = portal.portal_skins

    unique_emails = self.portal_properties.portaltransport_properties.unique_emails
    if unique_emails:
        for skinName in skinstool.getSkinSelections():
            path = skinstool.getSkinPath(skinName)
            path = [i.strip() for i in path.split(',')]
            if mailtransportSkin not in path:
                try:
                    path.insert(path.index('custom')+1, mailtransportSkin)
                except:
                    path.append(mailtransportSkin)

            path = ','.join(path)
            skinstool.addSkinSelection(skinName, path)
    else:
        for skinName in skinstool.getSkinSelections():
            path = skinstool.getSkinPath(skinName)
            path = [i.strip() for i in path.split(',')]
            while mailtransportSkin in path:
                del path[path.index(mailtransportSkin)]

            path = ','.join(path)
            skinstool.addSkinSelection(skinName, path)

    print >> out, "Successfully installed forum skins."
