# -*- coding: UTF-8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-
# Author: Nik Kim <fafhrd@legco.kz>
__version__ = '$Revision: 1.12 $'[11:-2]

import sys, random, traceback
from Acquisition import aq_parent, aq_inner
from Globals import InitializeClass
from AccessControl import ClassSecurityInfo

from OFS.Folder import Folder
from Products.CMFCore.utils import UniqueObject
from Products.CMFCore.CMFCorePermissions import ManagePortal
from Products.Archetypes.config import TOOL_NAME

# SMPT service support
try:
    from Products.SMTPService import getSMTPservice
    from Products.SMTPService.ISMTPHandler import ISMTPHandler
    hasSMTPservice = 1
except:
    hasSMTPservice = 0

import email
from email import message_from_string
from email.Message import Message
from email.Utils import parseaddr, formataddr
from email.Header import decode_header, make_header
from email.MIMENonMultipart import MIMENonMultipart

from debug import log
from config import mailtransportSkin, PROJECTNAME, error_templates
from MailTransportInfo import MailTransportInfo


class MailTransport( UniqueObject, Folder ):
    """ """
    id = 'portal_mailtransport'
    meta_type = 'PortalTransport Mail Transport'
    title = meta_type

    security = ClassSecurityInfo()

    if hasSMTPservice:
        __implements__ = (ISMTPHandler,)

    security.declareProtected(ManagePortal, 'addEMails')
    def addRecipient(self, uid):
        """ """
        tool = getattr(aq_parent(aq_inner(self)), TOOL_NAME)

        ob = tool.lookupObject(uid)

        if ob is None:
            raise Exception, 'Object not found.'

        id = str(random.random())[2:]
        info = MailTransportInfo(id, ob)
        self._setObject(id, info)

    security.declareProtected(ManagePortal, 'deleteEMails')
    def deleteRecipient(self, uid):
        """ """
        l = {}
        for ob in self.objectValues():
            l[ob.UID()] = ob
            
        for u in uid:
            if l.has_key(u):
                self._delObject(l[u].getId())

    def manage_afterAdd(self, item, container):
        if hasSMTPservice:
            self.activate()
            
        portal = aq_parent(aq_inner(self))
        skinstool = self.portal_skins
        props = portal.portal_properties.portaltransport_properties

        props.unique_emails = 1

        for skinName in skinstool.getSkinSelections():
            path = skinstool.getSkinPath(skinName)
            path = [i.strip() for i in path.split(',')]
            if mailtransportSkin not in path:
                try:
                    path.insert(path.index('custom')+1, mailtransportSkin)
                except:
                    path.append(mailtransportSkin)

            path = ','.join(path)
            skinstool.addSkinSelection(skinName, path)

    def manage_beforeDelete(self, item, container):
        if hasSMTPservice:
            self.deactivate()

        portal = aq_parent(aq_inner(self))
        skinstool = self.portal_skins
        props = portal.portal_properties.portaltransport_properties

        props.unique_emails = 0

        for skinName in skinstool.getSkinSelections():
            path = skinstool.getSkinPath(skinName)
            path = [i.strip() for i in path.split(',')]
            while mailtransportSkin in path:
                del path[path.index(mailtransportSkin)]

            path = ','.join(path)
            skinstool.addSkinSelection(skinName, path)

    security.declarePrivate('replyError')
    def replyError(self, category, template, info, error_msg, content=None):
        """ """
        portal = aq_parent(aq_inner(self))
        spool = portal.portal_mailspool
        pmt = portal.portal_mailtemplates

        headers = {'To': error_msg['From']}

        if content is None:
            headers['From']= formataddr(
                (portal.email_from_name, portal.email_from_address))
        else:
            try:
                headers['From']= content.getContentEmail()
            except:
                headers['From']= formataddr(
                    (portal.email_from_name, portal.email_from_address))
                   
        try:
            headers['In-Reply-To'] = error_msg['Message-Id']
        except:
            pass

        # attache errro message
        attached = MIMENonMultipart('message', 'rfc822')
        attached['Content-Disposition'] = 'inline'
        attached.set_payload([error_msg])

        # generate reply message
        message = pmt.createMultipartMessage(
            category, template, info, headers, messages=(attached,),
            multipart_format='mixed')
        
        spool.sendmail(self.email_from_address, [str(error_msg['From'])], message)

    security.declarePrivate('check_mail')
    def check_mail(self, message, raw_message):
        """ check for loop, spam, etc """
        props = self.portal_properties.portaltransport_properties

        if props.max_size and (len(raw_message) > props.maz_size):
            log('Max size exceeded %s' % len(raw_message))
            return 1

        # Check for MTA IP
        mtahosts = [ip for ip in props.mta_ips if ip]
        if mtahosts:
            try:
                request = self.REQUEST

                if 'HTTP_X_FORWARDED_FOR' in request.environ.keys():
                    REMOTE_IP = request.environ['HTTP_X_FORWARDED_FOR']
                else:
                    REMOTE_IP = request.environ['REMOTE_ADDR']

                if REMOTE_IP not in mtahosts:
                    log('Host %s is not allowed' % (REMOTE_IP))
                    return 1
            except:
                tracebac.print_exc()

        # check x-mailer
        mailer = props.mailer
        if message.get('X-Mailer') == mailer:
            log('Loop detected')
            return 1

        return 0

    security.declarePrivate('check_command')
    def check_command(self, msg):
        """ """
        subj = ''
        for s in msg.get_all('Subject'):
            subj += s

        subject = u''
        for s, charset in decode_header(subj):
            try:
                if charset is None:
                    subject += unicode(s)
                else:
                    subject += unicode(s, charset)
            except:
                traceback.print_exc()

        if subject.find('command:') >= 0:
            commands = self.portal_properties.portaltransport_properties.commands
            for command in commands:
                if subject.find(command.strip()) >= 0:
                    return command

        return None

    security.declarePublic('deliver')
    def deliver(self, email):
        """ delivery process """
        portal = aq_parent(aq_inner(self))
        atool = getattr(portal, TOOL_NAME)
        mtool = portal.portal_membership

        try:
            if isinstance(email, Message):
                msg = email
            else:
                msg = message_from_string(email)
        except Exception, e:
            log('MailTransport.deliver Error parsing email: %s' % e)
            return

        # check destination
        to_hdr = parseaddr(msg['To'])[1]
        dest_ob = None
        for ob in self.objectValues():
            if ((ob.reply_to == to_hdr) or
                (ob.return_path == to_hdr)):
                dest_ob = ob
                break
    
        if dest_ob is None:
            self.replyError(PROJECTNAME, error_templates[2],
                            {'portal_email': portal.email_from_address,
                             'portal_email_from': portal.email_from_name
                             }, msg)
            log("Can't find destination location.")
            return

        # check message for loops, wrong mta hosts
        if self.check_mail(msg, email):
            return 0
        log('check mail OK')

        #print message.as_string()

        # deliver
        dest_ob.deliver(self, to_hdr, msg, portal)


    #####################################################
    #  Helper methods for recipients objects
    #####################################################
    security.declarePrivate('get_loads')
    def get_loads(self, message, number=None):
	lst = []
	msgs = message.get_payload()
	type = message.get_type()
	if type == 'application/octet-stream' :
	    lst.append(msgs)
	    return lst

	for msg in msgs :
	    if msg.is_multipart() :
		loads = self.get_loads(msg)
		lst = lst + loads
	    else :
		lst.append(msg)
	if number != None :
	    return lst[number]
	return lst

    security.declarePrivate('getMessageSubject')
    def getMessageSubject(self, msg, charset):
        """ """
        title = make_header(
            decode_header(msg.get('Subject').strip())).__unicode__().encode(charset)
        if not title:
            title="[No subject]"
        return title

    security.declarePrivate('getParsedBody')
    def getParsedBody(self, msg, charset):
        """ return parsed body """
        def conv(st, cs):
            charsets = ['koi8-r', 'cp1251', 'iso-8859-1']
            if cs is not None:
                charsets = [cs] + charsets

            for cs in charsets:
                try:
                    return unicode(st, cs, 'replace').encode(charset)
                except:
                    pass
            return st
        
        if msg.is_multipart():
            for msg in self.get_loads(msg):
                type = msg.get_type()
                if type == None :
		    type = 'text/plain'
		if type == 'text/plain':
                    return conv(msg.get_payload(decode=1),
                                msg.get_content_charset()), 'text/plain'
		if type == 'text/html':
		    return conv(msg.get_payload(decode=1),
                                msg.get_content_charset()), 'text/html'

            return '', ''
        else:
            st = msg.get_payload(decode=1)
            if st is None: return '', 'text/plain'
            st = conv(st, msg.get_content_charset())
            
	    st = email.quopriMIME.decode(st)
            
	    if msg.get_type() == 'text/html':
                return st, 'text/html'
	    else:
                return st, 'text/plain'

    security.declarePrivate('genMessageId')
    def genMessageId(self, content):
        """ """
        s = '<%s@portaltransport>' % content.UID()
        return s

    security.declarePrivate('getObjectsFromId')
    def getObjectsFromId(self, reply_to):
        """ """
        tool = getattr(aq_parent(aq_inner(self)), TOOL_NAME)
        uid = reply_to[1:-1].split('@')[0]
        return tool.lookupObject(uid)


    ##############################
    ##  ISMTPHandler
    ##############################
    security.declarePrivate('process_message')
    def process_message(self, from_addr, message, localpart, domain):
        """ process one message """
        message['from'] = from_addr
        message['to'] = '%s@%s'%(localpart, domain)
        self.deliver(message)

    security.declarePrivate('can_handle_message')
    def can_handle_message(self, message, localpart, domain):
        """ """
        to_addr = '%s@%s'%(localpart, domain)
        for ob in self.objectValues():
            if ((ob.reply_to == to_addr) or
                (ob.return_path == to_addr)):
                return 1
        return 0

    security.declareProtected( ManagePortal, 'isActive' )
    def isActive( self ):
        """ """
        service = getSMTPservice(self)
        return service and not not service.listSubscriptions( self._event_stub )

    security.declareProtected( ManagePortal, 'activate' )
    def activate( self ):
        """ """
        if hasSMTPservice:
            service = getSMTPservice(self)
            if not service:
                raise ValueError, "Can't find event service!"

            service.subscribe( self )

    security.declareProtected( ManagePortal, 'deactivate' )
    def deactivate( self ):
        """ """
        if hasSMTPservice:
            service = getSMTPservice(self)
            if not service:
                raise ValueError, "Can't find event service!"

            service.unsubscribe( self )

InitializeClass(MailTransport)
