# -*- coding: UTF-8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-
# Authors: Nik Kim <fafhrd@legco.biz> 
__version__ = '$Revision: 1.3 $'[11:-2]

import re, traceback
from Globals import InitializeClass
from DateTime import DateTime
from Acquisition import aq_base, aq_inner, aq_parent
from AccessControl import ClassSecurityInfo
from Products.CMFCore.utils import getToolByName
from Products.Archetypes.public import *
from Products.Archetypes.config import TOOL_NAME
from Products.Archetypes.interfaces.referenceable import IReferenceable
from email.Utils import formataddr

from config import *
from utils import make_uuid
from SubscriptionInfoBase import BaseSubscriptionInfo

schema = BaseSchema + Schema((
    StringField('fullname', required=0,
                write_permission=ModifyPortalContent,
                widget=StringWidget(label='Fullname',
                                    label_msgid='label_fullname',
                                    description_msgid='help_fullname',
                                    i18n_domain='PortalTransport')),
    StringField('email', required=1,
                validators=('isEmail',),
                widget=StringWidget(label='Email',
                                    label_msgid='label_email',
                                    description_msgid='help_email',
                                    i18n_domain='PortalTransport')),
    StringField('text_format', default='plain',
                widget=SelectionWidget(label='Message format',
                                       label_msgid='label_text_format',
                                       description_msgid='help_text_format',
                                       i18n_domain='PortalTransport')),
    ))


def addPT_SIAnonymous(self, oid, uid, content, email, fullname, **kw):
    ob = PT_SIAnonymous(oid, uid, content, email, fullname, **kw)
    return self._setObject(oid, ob)


class PT_SIAnonymous(BaseSubscriptionInfo):
    """ class for manage single subscription """
    security = ClassSecurityInfo()

    schema = schema

    member_id = 'Anonymous User'
    
    def __init__(self, oid, uid, content, email, fullname,
                 text_format='plain', hint='', **kwargs):
        BaseSubscriptionInfo.__init__(self, oid, uid, content, hint,
                                      text_format=text_format, **kwargs)

        self.getField('email').set(self, email)
        self.getField('fullname').set(self, fullname)
        self.getField('text_format').set(self, text_format)

    security.declarePublic('isAutoActivate')
    def isAutoActivate(self):
        """ """
        try:
            return self.getSubscribedContent().isAutoActivateAnonymousSubscription()
        except:
            return 0

    def _getInfo(self, content):
        return {'email': self.email,
                'fullname': self.fullname,
                'member': None,
                }

    def getEmail(self):
	""" """
        return formataddr((self.getField('fullname').get(self),
                           self.getField('email').get(self)))

    security.declarePublic('getTextFormat')
    def getTextFormat(self):
        """ """
        return self.getField('text_format').get(self)

    security.declarePublic('confirm')
    def confirm(self, REQUEST=None):
        """ """
        review_state = self.review_state()
        if review_state == 'activation':
            self.wm_activate()
        elif review_state == 'deactivation':
            self.wm_deactivate()
        else:
            raise ValueError, "No need action confirmation."

        if REQUEST is not None:
            REQUEST.RESPONSE.redirect(
                '%s/?portal_status_message=Action+confirmed.'%
                getToolByName(self, 'portal_url').getPortalObject().absolute_url())

    security.declarePublic('unsubscribe')
    def unsubscribe(self):
        """ """
        content = self.getSubscribedContent()
        
        if self.review_state() == 'activation':
            self.wm_deactivate()
        else:
            self.wm_deactivation()
            
        return content
        
registerType(PT_SIAnonymous)
