# -*- coding: UTF-8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-
# Author: Nik Kim <fafhrd@legco.biz>
"""
$Id: templates.py,v 1.22 2004/03/25 10:01:43 clebeaupin Exp $
"""

from config import PROJECTNAME

error_1 = {'title': 'Error 1',
           'description': 'Member not found.',
           'mail_subject': "python:here.translate('error_member_not_found',default='Error (Member not found.)')",
           'mail_body':
"""<tal:block i18n:domain="PortalTransport" i18n:translate="text_error_1">

Member not found.

_____________________________
"<tal:block i18n:name="portal_title" content="options/portal_title"/>" <tal:block content="options/portal_url" i18n:name="portal_url" />
</tal:block>
"""}

error_2 = {'title': 'Error 2',
           'description': 'Content not found.',
           'mail_subject': "python:here.translate('error_content_not_found',default='Error (Content not found.)')",
           'mail_body':
"""<tal:block i18n:domain="PortalTransport" i18n:translate="text_error_2">
System error (Content not found).
Please contact with system administrator.
"<tal:block i18n:name="portal_email_form" content="options/portal_email_from"/>" mailto:<tal:block content="options/portal_email" i18n:name="portal_email" />
_____________________________
"<tal:block i18n:name="portal_title" content="options/portal_title"/>" <tal:block content="options/portal_url" i18n:name="portal_url" />
</tal:block>
"""}

error_3 = {'title': 'Error 3',
           'description': 'More than one members.',
           'mail_subject': "python:here.translate('error_more_than_one_member', default='Error (More than one members.)')",
           'mail_body':
"""<tal:block i18n:domain="PortalTransport" i18n:translate="text_error_3">

More than one members found with your email.
Please contact with system administrator.
"<tal:block i18n:name="portal_email_form" content="options/portal_email_from"/>" mailto:<tal:block content="options/portal_email" i18n:name="portal_email" />
_____________________________
"<tal:block i18n:name="portal_title" content="options/portal_title"/>" <tal:block content="options/portal_url" i18n:name="portal_url" />
</tal:block>
"""}

error_4 = {'title': 'Error 4',
           'description': "Recipient can\'t receive mails.",
           'mail_subject': "python:here.translate('error_cant_receive',default='Error (Recipient can\\'t receive mails.)')",
           'mail_body':
"""<tal:block i18n:domain="PortalTransport" i18n:translate="text_error_4">

Recipient can't receive mails.

_____________________________
"<tal:block i18n:name="portal_title" content="options/portal_title"/>" <tal:block content="options/portal_url" i18n:name="portal_url" />
</tal:block>
"""}


subscribed_message = {'title': 'Subscribed message',
                      'mail_subject': "python:options['content_title'] + ' ' + here.translate('text_subs_ok', default='subscription OK.')",
                      'mail_body':
"""<tal:block i18n:domain="PortalTransport" i18n:translate="text_subscribed_message"><tal:block i18n:name="fullname" content="options/fullname" />,

Welcome!

You have now been subscribed to receive <tal:block i18n:name="content_title" content="options/content_title"/> messages from <tal:block i18n:name="portal_title" content="options/portal_title"/>.

Messages will be sent to this email address: <tal:block i18n:name="email" content="options/email"/>

If this subscription was a mistake and you do NOT want to receive <tal:block i18n:name="content_title" content="options/content_title"/> messages, 
please click on this link: <tal:block i18n:name="unsubscribe_url" content="options/unsubscribe_url"/>

<tal:block tal:condition="nothing">
or send a blank message to the following email address and you will be REMOVED from the mailing list:</tal:block>

_____________________________
<tal:block i18n:name="portal_url" content="options/portal_url" />
</tal:block>
"""}

subscription_activation = {
  'title': 'Subscription confirmation message',
  'mail_subject': "python:here.translate('text_confirm_subscrption_to',default='Please confirm subscription to') + ' ' + options['content_title']",
  'mail_body':
"""<tal:block i18n:domain="PortalTransport" i18n:translate="text_subscription_activation">
Just one more step: 

Please reply to this message to confirm that you want to receive the <tal:block content="options/content_title" i18n:name="content_title" />.

If this was a mistake and you do not want to receive the <tal:block i18n:name="content_title" content="options/content_title"/> emails, do nothing. You will be automatically removed.

To confirm that you do want to receive the newsletter and that we have your correct email address, go to <tal:block i18n:name="confirm_url" content="options/confirm_url"/>.

Thank you for your interest in the <tal:block i18n:name="content_title" content="options/content_title"/>

</tal:block>
"""}

subscription_deactivation = {
        'title': 'Unsubscribe confirmation message',
        'mail_subject': "python:here.translate('text_confirm_remove_subscription', default='Please confirm subscription removal from') + ' ' + options['content_title']",
        'mail_body':
"""<tal:block i18n:domain="PortalTransport" i18n:translate="text_subscription_deactivation">
Just one more step: 

Please reply to this message to confirm that you want to unsubscribe from <tal:block content="options/content_title" i18n:name="content_title" />.

If this was a mistake and you still want to receive the <tal:block content="options/content_title" i18n:name="content_title" /> emails, do nothing. Your subscription will remain.

To confirm that you do not want to receive the newsletter, go to <tal:block content="options/confirm_url" i18n:name="confirm_url" />.

Thank you for your interest in the <tal:block i18n:name="content_title" content="options/content_title"/>

</tal:block>
"""}


unsubscribed_message = {
        'title': 'Unsubscribed message',
        'mail_subject': "python:options['content_title'] + ' ' + here.translate('text_unsubs_confirm', default='unsubscribe confirmation')",
        'mail_body':
"""<tal:block i18n:domain="PortalTransport" i18n:translate="text_unsubscribed_message">
<tal:block i18n:name="email" content="options/email"/> has now been unsubscribed from the <tal:block i18n:name="content_title" content="options/content_title"/>.

You should not receive any further email from the <tal:block i18n:name="content_title" content="options/content_title"/>.

If you want to resume getting the <tal:block i18n:name="content_title" content="options/content_title"/> in the future, please go to <tal:block i18n:name="portal_url" content="options/portal_url"/>
</tal:block>
"""}



templates = {
    PROJECTNAME:
    {'attributes': {'title':'PortalTransport mail templates',},
     'scripts': {},
     'templates': {'error_1': error_1,
                   'error_2': error_2,
                   'error_3': error_3,
                   'error_4': error_4,
                   'subscribed_message': subscribed_message,
                   'unsubscribed_message': unsubscribed_message,
                   'subscription_activation': subscription_activation,
                   'subscription_deactivation': subscription_deactivation,
                   }
     }
    }
