# -*- coding: UTF-8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-
# Author: Nik Kim <fafhrd@legco.biz>
__version__ = '$Revision: 1.9 $'[11:-2]

import time, random, md5, socket
from email.Utils import formataddr
from email.Header import decode_header
from Acquisition import aq_base
from Products.PythonScripts.PythonScript import manage_addPythonScript
from Products.CMFCore.utils import getToolByName, _checkPermission
from Products.CMFCore.CMFCorePermissions import ManagePortal

# word-wrap function that preserves line breaks and spaces
# (from http://aspn.activestate.com/ASPN/Cookbook/Python/Recipe/148061)
def wrap(s, width=72):
    return reduce(lambda line, word, width=width: '%s%s%s' %
                  (line,
                   ' \n'[(len(line[line.rfind('\n')+1:])
                          + len(word.split('\n',1)[0]
                                ) >= width)],
                   word),
                  s.split(' ')
                  )


def install_mail_templates(self, portal, templates_data, out):
    pmt = portal.portal_mailtemplates

    for category, data in templates_data.items():
        c_ob = pmt.createCategory(category, **data['attributes'])

        scripts = c_ob.scripts
        for id, body in data.get('scripts', {}).items():
            if not hasattr(aq_base(scripts), id):
                manage_addPythonScript(scripts, id)
                s = scripts._getOb(id)
                s.write(body)
            
        for template, attrs in data['templates'].items():
            if not hasattr(c_ob, template):
                c_ob.invokeFactory('PT_MailTemplate', template, **attrs)
        

# code from Archetypes-1.3
try:
    _v_network = socket.gethostbyname(socket.gethostbyname())
except:
    _v_network = random.random() * 100000000000000000L

def make_uuid(*args):
    t = long(time.time() * 1000)
    r = long(random.random()*100000000000000000L)
    data = str(t)+' '+str(r)+' '+str(_v_network)+' '+str(args)
    data = md5.md5(data).hexdigest()
    return data


def change_email_for_member(self, member, email):
    portal = getToolByName(self, 'portal_url').getPortalObject()

    if _checkPermission(ManagePortal, portal):
        member.setMemberProperties({'email': email})

def check_member_email(self, email, registration=0):
    members = self.portal_membership.searchMembers('email', email)

    if not registration:
        member=self.portal_membership.getAuthenticatedMember()
        m = {'username': member.getUserName(),
             'email': member.getProperty('email')}
        if m in members:
            members.remove(m)

    if members:
        return 1
    else:
        return 0
