from __future__ import nested_scopes

from Products.CMFCore.Skinnable import superGetAttr, _marker
from Products.CMFDefault.Portal import CMFSite as OldSite
from Products.SpeedPack import SPEEDPACK_CACHE_TTL
from Acquisition import aq_base
from AccessControl import ClassSecurityInfo
import Globals
import time


class SitePatch:
    security=ClassSecurityInfo()

    # The methods below override Skinnable to speed up skin object resolution.
    # One big change: the custom folder now behaves like FSDirectoryViews in 
    # that if you are not in debug mode and you add or delete an object from
    # custom, the addition/deletion will not be noticed by the skin resolver.
    #
    # That's why you need a special folder called Skin Custom Folder which purges
    # the internal skin every time an objects is changed.
    # 
    # CAUTION: if you delete a skin object from custom while this optimization
    # is running and you are not in debug mode, you need to restart Zope or 
    # arrange to call _invalidateHitCache!

    security.declarePublic('changeSkin')
    def changeSkin(self, skinname):
        '''Change the current skin.
        
        Can be called manually, allowing the user to change
        skins in the middle of a request.
        '''
        self._v_skindata = None
        skinobj = self.getSkin(skinname)
        if skinobj is not None:
            ignore, resolve = self._getHitCache(skinname)
            self._v_skindata = (self.REQUEST, skinobj, ignore, resolve)


    def _getHitCache(self, skinname):
        now = time.time()
        (hitcache, t) = getattr(self, '_v_hitcache', (None, 0))
        if hitcache is None or \
          (Globals.DevelopmentMode and now - t > SPEEDPACK_CACHE_TTL):  # expire cache in development mode
            self._v_hitcache = ({}, time.time())
            (hitcache, t) = getattr(self, '_v_hitcache', (None, 0))
        if not hitcache.has_key(skinname):
            hitcache[skinname] = ({},{})
        return hitcache[skinname]


    def _invalidateHitCache(self):
        self._v_hitcache = ({}, time.time())
        

    def __getattr__(self, name):
        '''
        Looks for the name in an object with wrappers that only reach
        up to the root skins folder.  
        
        This should be fast, flexible, and predictable.
        '''
        if not name.startswith('_') and not name.startswith('aq_'):
            sd = self._v_skindata
            if sd is not None:
                request, ob, ignore, resolve = sd
                if not ignore.has_key(name):
                    if resolve.has_key(name):
                        return resolve[name]
                    subob = getattr(ob, name, _marker)
                    if subob is not _marker:
                        # Return it in context of self, forgetting
                        # its location and acting as if it were located
                        # in self.
                        retval = aq_base(subob)
                        resolve[name] = retval
                        return retval
                    else:
                        ignore[name] = 1
        if superGetAttr is None:
            raise AttributeError, name
        return superGetAttr(self, name)

    ###
    # test for cmf 1.3. If found change setupCurrentSkin() and add 
    # getSkinNameFromRequest() and getSkin(). The code is taken from cmf 1.4
    ###
    if not hasattr(OldSite, 'changeSkin'):
        # it's CMF 1.3.x
        security.declarePublic('setupCurrentSkin')
        def setupCurrentSkin(self, REQUEST=None):
            '''
            Sets up _v_skindata so that __getattr__ can find it.
    
            Can NOT be called manually to change skins in the middle of a 
            request! Use changeSkin for that.
            '''
            if REQUEST is None:
                REQUEST = getattr(self, 'REQUEST', None)
            if REQUEST is None:
                # self is not fully wrapped at the moment.  Don't
                # change anything.
                return
            if self._v_skindata is not None and self._v_skindata[0] is REQUEST:
                # Already set up for this request.
                return
            skinname = self.getSkinNameFromRequest(REQUEST)
            self.changeSkin(skinname)
        
        security.declarePublic('getSkinNameFromRequest')
        def getSkinNameFromRequest(self, REQUEST=None):
            '''Returns the skin name from the Request.'''
            sfn = self.getSkinsFolderName()
            if sfn is not None:
                sf = getattr(self, sfn, None)
                if sf is not None:
                    return REQUEST.get(sf.getRequestVarname(), None)
                
        security.declarePrivate('getSkin')
        def getSkin(self, name=None):
            """Returns the requested skin.
            """
            skinob = None
            skinstool = None
            sfn = self.getSkinsFolderName()

            if sfn is not None:
                sf = getattr(self, sfn, None)
                if sf is not None:
                   if name is not None:
                       skinob = sf.getSkinByName(name)
                   if skinob is None:
                       skinob = sf.getSkinByName(sf.getDefaultSkin())
                       if skinob is None:
                           skinob = sf.getSkinByPath('')
            return skinob


Globals.InitializeClass(SitePatch)

