#####################################################################
# 
# Xron -- Zope Scheduled Event Product
# Copyright (C) 2000 Loren Stafford
#  
# Derived from the ZScheduler product version 0.0.7 in accord 
# with the terms of the ZScheduler's license.
#
# Based on code by Martijn Pieters, (c) 1999 Antraciet B.V.
# Used with explicit permission.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License  
# along with this program; if not, write to the 
#     Free Software Foundation, Inc., 
#     59 Temple Place - Suite 330, 
#     Boston, MA  02111-1307, USA.
# 
#####################################################################
""" Logger for Xron """

import zLOG
import sys, traceback, string

def loggerr(severity, summary, detail='', error=None, reraise=None):
  if severity > 199:
    type, val, tb = sys.exc_info()
    fe=traceback.format_exception (type, val, tb) 
    zLOG.LOG(__name__, severity, summary, string.join(fe, ''), 
      (type, val, tb), reraise)
    del type, val, tb
  else:
    zLOG.LOG(__name__, severity, summary, detail, None, reraise)

