#####################################################################
# 
# Xron -- Zope Scheduled Event Product
# Copyright (C) 2000 Loren Stafford
#  
# Derived from the ZScheduler product version 0.0.7 in accord 
# with the terms of the ZScheduler's license.
#
# Based on code by Martijn Pieters, (c) 1999 Antraciet B.V.
# Used with explicit permission.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License  
# along with this program; if not, write to the 
#     Free Software Foundation, Inc., 
#     59 Temple Place - Suite 330, 
#     Boston, MA  02111-1307, USA.
# 
#####################################################################
""" Schedule -- a Catalog of Sheduled Events """

from Globals import HTMLFile
import Globals
from Acquisition import aq_base
from OFS.Folder import Folder
from Products.ZCatalog import ZCatalog
from Products.ZCatalog import Catalog
try:
  from Globals import DateTime
except ImportError:
  from DateTime import DateTime
from threading import Event

# The one instance of Schedule has an ID known to all XronDTMLMethods
ScheduleID='Schedule'  # The well-known ID for the Schedule
ScheduleChange=Event() # Communicate Schedule changes to Dispatcher

class EventSchedule(ZCatalog.ZCatalog):
  """ The Schedule (catalog of events). This is also a container. """

  meta_type = 'EventSchedule'
  icon='misc_/Xron/EventScheduleIcon'

  manage_options = (
    {'label':'Cataloged Objects', 'action': 'manage_catalogView'},
    {'label':'Contents', 'action':'manage_main'},
    {'label':'Import/Export', 'action':'manage_importExportForm'},
    {'label':'Security', 'action':'manage_access'},
    {'label':'Undo', 'action':'manage_UndoForm'},
  )

  __ac_permissions__ = (
    ('View management screens', 
      ('manage_main','manage_menu','manage_catalogView')),
    ('Access contents information',
      ('objectIds', 'objectValues', 'objectItems',''),
      ('Anonymous', 'Manager')),
    ('Delete objects', ('manage_delObjects',)),
    ('Import/Export objects', (
      'manage_importObject','manage_importExportForm',
      'manage_exportObject')),
  )

  manage_catalogView = HTMLFile('scheduleView',globals())

  def __init__(self, id='Schedule', title='Scheduled Event Catalog'):
    self.id = id
    self.title = title
    self.threshold = 1000
    self._v_total = 0
    self._catalog = ZCatalog.Catalog()

    base = aq_base(self)
    if hasattr(base, 'addIndex'):
        # Zope 2.4
        addIndex = self.addIndex
    else:
        # Zope 2.3 and below
        addIndex = self._catalog.addIndex
    if hasattr(base, 'addColumn'):
        # Zope 2.4
        addColumn = self.addColumn
    else:
        # Zope 2.3 and below
        addColumn = self._catalog.addColumn

    addColumn('id')
    addColumn('meta_type')
    addColumn('nextEventTime')
    addIndex('nextEventTime', 'FieldIndex')
    addColumn('absolute_url')
    addIndex('absolute_url', 'FieldIndex')

  # Extensions to ZCatalog methods
  def catalog_object(self, obj, uid):
    """ extend ZCatalog to set ScheduleChange event """
    ZCatalog.ZCatalog.catalog_object.im_func(self, obj, uid)
    # see Python Reference Manual "The standard type hierarchy" 
    # for the built-in type im_func
    ScheduleChange.set()
      
  def uncatalog_object(self, uid):
    """ extend ZCatalog to set ScheduleChange event """
    try: ZCatalog.ZCatalog.uncatalog_object.im_func(self, uid)
    except ValueError: pass
    # see Python Reference Manual "The standard type hierarchy" 
    # for the built-in type im_func
    ScheduleChange.set()

  # Query the event catalog
  def armed_event(self):
    """ get the first event that is armed """
    #import pdb; pdb.set_trace()
    next_url=None
    next_time=None
    next_uid=None
    for event in self._catalog.searchResults(
            nextEventTime=DateTime(1),
            nextEventTime_usage='range:min',
            sort_on='nextEventTime'
            ):
      next_url = event.absolute_url
      next_time = event.nextEventTime
      break  # just look at the first one
    return (next_time, next_url)

  # Last resort method for disarming a failed event
  def exterminate(self, aurl):
    for event in self._catalog.searchResults(absolute_url=aurl):
      # broken into 3 statements for tracing
      rid=event.data_record_id_
      uid=self._catalog.getpath(rid)
      self.uncatalog_object(uid)
      #self.uncatalog_object(self._catalog.getpath(event.data_record_id_))

Globals.default__class_init__(EventSchedule)
