#####################################################################
# 
# Xron -- Zope Scheduled Event Product
# Copyright (C) 2000 Loren Stafford
#  
# Derived from the ZScheduler product version 0.0.7 in accord 
# with the terms of the ZScheduler's license.
#
# Based on code by Martijn Pieters, (c) 1999 Antraciet B.V.
# Used with explicit permission.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License  
# along with this program; if not, write to the 
#     Free Software Foundation, Inc., 
#     59 Temple Place - Suite 330, 
#     Boston, MA  02111-1307, USA.
# 
#####################################################################
""" Xron -- Zope Scheduled Event Product """

import Loggerr
loggerr=Loggerr.loggerr

import Schedule
ScheduleID=Schedule.ScheduleID
ScheduleChange=Schedule.ScheduleChange

import XronDTMLMethod       
import RPC
import Dispatcher

from Globals import ImageFile
from threading import Thread

#import pdb; pdb.set_trace()

# We only want one instance of the EventSchedule class,
# therefore we're not using registerClass
# Because no registerClass, 
# use the old method to set the icon for the Schedule object
misc_ = { 'EventScheduleIcon': ImageFile('www/Schedule.gif', globals()) }

def initialize(context):
  try:
    # Add the schedule catalog to the Zope root, 
    app = context._ProductContext__app

    global Schedule
    if hasattr(app, ScheduleID):
      #loggerr(0, 'Found existing '+ScheduleID)
      Schedule = getattr(app, ScheduleID, None)
    else:
      #loggerr(0, 'Starting to create '+ScheduleID)
      try: # creating Schedule catalog
        oSchedule=Schedule.EventSchedule(id=ScheduleID, title='Scheduled Event Catalog')
        app._setObject(ScheduleID, oSchedule)
        #prod = context._ProductContext__prod
        #setattr(prod, 'manage_beforeDelete', beforeDeleteHook())
        get_transaction().note('Added Schedule')
        get_transaction().commit()
        loggerr(0, 'Created new '+ScheduleID)
      except: # if you can't create the catalog, tell someone.
        loggerr(200, 'Failed to create new '+ScheduleID)
      Schedule = getattr(app, ScheduleID, None)

    assert Schedule is not None

    #if 'Scheduler' not in app._reserved_names:
    #    app._reserved_names = app._reserved_names + ('Scheduler',)

    # register XronDTMLMethod class
    #loggerr(0, 'Starting to register event class.')
    try: 
      context.registerClass(
        XronDTMLMethod.XronDTMLMethod,
        permission = 'Add Scheduled Method',
        constructors = (
          XronDTMLMethod.manage_addXronDTMLMethodForm,
          XronDTMLMethod.manage_addXronDTMLMethod),
        icon = 'www/Event.gif')
      context.registerBaseClass(XronDTMLMethod.XronDTMLMethod)
      context.registerHelp()
    except: # if you can't register the class, tell someone.
      loggerr(200, 'Failed to register XronDTMLMethod class.')
      import sys, traceback, string
      type, val, tb = sys.exc_info()
      sys.stderr.write(string.join(
        traceback.format_exception(type, val, tb), ''))
      del type, val, tb    

    # Start the Dispatcher thread
    #loggerr(0, 'Creating Dispatcher thread.')
    dispatcher=Dispatcher.Dispatcher(target=Dispatcher.Timer, name='EventTimer', 
                                     args=(ScheduleID, ScheduleChange, RPC.rpc))

  except:
    import traceback
    traceback.print_exc()

#class beforeDeleteHook(Persistent):
#    """ Make sure that the Scheduler object can be deleted
#        This should be persistent....
#    """
#    def __call__(self, prod, products):
#        app = products.aq_parent.aq_parent
#        rn = list(app._reserved_names)
#        try:
#            rn.remove('Scheduler')
#            app._reserved_names = tuple(rn)
#        except ValueError:
#            pass
