###################################################################################################
# _objattrs.py
#
# $Id: _objattrs.py,v 1.8 2004/02/24 19:57:21 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.8 $
#
# Implementation of class ObjAttrs (see below).
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
from __future__ import nested_scopes
from DateTime.DateTime import DateTime
import ZPublisher.HTTPRequest
import copy
import time
import urllib
# Product Imports.
import _blobfields
import _globals


# ---------------------------------------------------------------------------------------------
#  _objattrs.hasobjattr:
# ---------------------------------------------------------------------------------------------
def hasobjattr(obj, key):
  try:
    id = obj.id
    keys = obj.__dict__.keys() 
    return key in keys
  except:
    return hasattr(obj,key)

# ---------------------------------------------------------------------------------------------
#  _objattrs.getobjattr:
# ---------------------------------------------------------------------------------------------
def getobjattr(self, obj, obj_attr, lang):
  key = self.getObjAttrName(obj_attr,lang)
  if hasobjattr(obj,key):
    value = getattr(obj,key)
  else:
    datatype = obj_attr['datatype_key']
    value = obj_attr.get('default',_globals.dtMapping[datatype][1])
  return value

# ---------------------------------------------------------------------------------------------
#  _objattrs.setobjattr:
# ---------------------------------------------------------------------------------------------
def setobjattr(self, obj, obj_attr, value, lang):
  key = self.getObjAttrName(obj_attr,lang)
  # Assign value.
  setattr(obj,key,value)

# ---------------------------------------------------------------------------------------------
#  _objattrs.cloneobjattr:
# ---------------------------------------------------------------------------------------------
def cloneobjattr(self, src, dst, obj_attr, lang):
  # Fetch value.
  v = getobjattr(self,src,obj_attr,lang)
  # Clone value.
  if v is not None:
    datatype = obj_attr['datatype_key']
    if datatype in _globals.DT_BLOBS:
      v = v._getCopy()
    elif datatype == _globals.DT_LIST or datatype in _globals.DT_DATETIMES:
      v = copy.copy(v) # copy.deepcopy(v)
    elif datatype == _globals.DT_DICTIONARY:
      v = v.copy()
    else:
      v = v
  # Assign value.
  setobjattr(self,dst,obj_attr,v,lang)

# ---------------------------------------------------------------------------------------------
#  _objattrs.syncobjattr:
# ---------------------------------------------------------------------------------------------
def syncobjattr(self, obj_attr):
  dct = obj_attr.copy()
  dct['xml'] = obj_attr.get('xml',1)
  dct['key'] = obj_attr.get('key',obj_attr.get('id',''))
  dct['label'] = obj_attr.get('label',dct.get('name',''))
  dct['mandatory'] = obj_attr.get('mandatory',0)
  dct['multilang'] = obj_attr.get('multilang',0)
  dct['lang_inherit'] = obj_attr.get('lang_inherit',1)
  dct['type'] = obj_attr.get('type','string')
  dct['datatype'] = obj_attr.get('datatype',obj_attr.get('type','string'))
  if obj_attr['type'] == 'password':
    dct['type'] = obj_attr['type']
    dct['datatype'] = 'string'
  elif obj_attr['type'] == 'select':
    dct['type'] = obj_attr['type']
    dct['datatype'] = 'string'
  elif obj_attr['type'] == 'multiselect':
    dct['type'] = obj_attr['type']
    dct['datatype'] = 'list'
  if len(obj_attr.get('keys',[]))>0:
    options = []
    for option in obj_attr['keys']:
      options.append(option)
      options.append(option)
    dct['options'] = options
  datatype = dct['datatype'].lower()
  dct['datatype_key'] = _globals.datatype_key(datatype)
  dct['type'] = obj_attr.get('type',datatype)
  return dct


###################################################################################################
###################################################################################################
###
###   O B J E C T   A T T R I B U T E S
###
###################################################################################################
###################################################################################################
class ObjAttrs:

    # ---------------------------------------------------------------------------------------------
    #	ObjAttrs.getObjAttrs:
    #
    #	Returns object-attributes and resolves meta-dictionaries.
    # ---------------------------------------------------------------------------------------------
    def getObjAttrs(self, meta_type=None):
      if meta_type is None:
        if self.meta_type == 'ZMSCustom':
          meta_type = self.meta_id
        else:
          meta_type = self.meta_type
      return self.dObjAttrs.get(meta_type,{})


    # ---------------------------------------------------------------------------------------------
    #  ObjAttrs.getObjAttr:
    # ---------------------------------------------------------------------------------------------
    def getObjAttr(self, key, meta_type=None):
      obj_attrs = self.getObjAttrs(meta_type)
      return obj_attrs.get(key,{'key':key,'xml':0,'datatype':'string','datatype_key':_globals.DT_UNKNOWN,'multilang':0,'lang_inherit':0})


    # ---------------------------------------------------------------------------------------------
    #  ObjAttrs.getObjOptions:
    # ---------------------------------------------------------------------------------------------
    def getObjOptions(self, obj_attr, REQUEST):
      optpl = []
      if obj_attr.has_key('options'):
        opts = []
        obj_attropts = obj_attr['options']
        if type(obj_attropts) is type([]):
          dtml = ''.join(map(lambda x: str(obj_attropts[x*2]),range(len(obj_attropts)/2)))
          if len(obj_attropts)==2 and self.getLinkObj(obj_attropts[0],REQUEST):
            ob = self.getLinkObj(obj_attropts[0],REQUEST)
            metaObj = self.getMetaobj(ob.meta_id)
            res = ob.getObjProperty(metaObj['attrs'][0]['id'],REQUEST)
            res = map(lambda x: {'key':x['key'],'value':x.get('value',x.get('value_%s'%REQUEST['lang']))},res)
            res = self.sort_list(res,'value','asc')
            opts = map(lambda x: [x['key'],x['value']],res)
          elif dtml.find('<dtml')>=0:
            try:
              opts = _globals.dt_html(self,dtml,REQUEST)
            except:
              opts = _globals.writeException(self,'[getObjOptions]: key=%s'%obj_attr['key'])
          else:
            for i in range(len(obj_attropts)/2):
              opts.append([obj_attropts[i*2],obj_attropts[i*2+1]])
        elif type(obj_attropts) is type({}):
          for k in obj_attropts.keys():
            opts.append([k,obj_attropts[k]])
        for opt in opts:
          lang_attr = 'OPT_'
          for skey in obj_attr['key'].split('_'):
            lang_attr += skey[0]
          lang_attr += '_' + str(opt[1]).replace(' ','')
          lang_attr = lang_attr.upper()
          lang_display = self.getLangStr(lang_attr,REQUEST['manage_lang'])
          value = str(opt[0])
          display = str(opt[1])
          if lang_attr != lang_display:
            display = lang_display
          display = self.string_maxlen(display,30)
          optpl.append([value,display])
      return optpl

    # ---------------------------------------------------------------------------------------------
    #  ObjAttrs.getObjAttrName:
    # ---------------------------------------------------------------------------------------------
    def getObjAttrName(self, obj_attr, lang=None):
      attr = obj_attr['key']
      if obj_attr['multilang']:
        attr = '%s_%s'%(attr,lang)
      return attr

    # ---------------------------------------------------------------------------------------------
    #  ObjAttrs.isDisabledAttr:
    # ---------------------------------------------------------------------------------------------
    def isDisabledAttr(self, obj_attr, REQUEST):
      lang = REQUEST.get('lang',self.getPrimaryLanguage())
      return not (obj_attr['multilang'] or REQUEST.get('ZMS_INSERT',None) is not None or self.getDCCoverage(REQUEST).find('.'+lang)>0)


    ###############################################################################################
    #
    #  I N P U T - F I E L D S
    #
    ###############################################################################################

    # ---------------------------------------------------------------------------------------------
    #  ObjAttrs.getObjAttrInput:
    # ---------------------------------------------------------------------------------------------
    def getObjAttrInput(self, fmName, obj_attr, value, REQUEST):
    
      #-- DATATYPE
      datatype = obj_attr['datatype_key']
      
      #-- NAME
      lang = REQUEST['lang']
      manage_lang = REQUEST['manage_lang']
      fmName = 'form0'
      elName = self.getObjAttrName(obj_attr,lang)
      
      #-- INPUTTYPE
      inputtype = obj_attr.get('type','string')
      
      #-- ENABLED / DISABLED
      enabled = not self.isDisabledAttr(obj_attr,REQUEST)
      disabled = obj_attr['key'].find('_')==0
      
      #-- ID-Fields.
      if inputtype == 'identifier':
        if value == '': value = 'e%i'%self.getSequence().nextVal()
        return '<div class="form-element"><code><input type="hidden" name="%s" value="%s">%s</code></div>'%(elName,value,value)

      #-- Image-Fields.
      if inputtype == 'image':
        return self.f_selectImage(self,ob=self,fmName=fmName,elName=elName,value=value,key=obj_attr['key'],lang=lang,manage_lang=manage_lang,REQUEST=REQUEST)
      
      #-- File-Fields.
      elif inputtype == 'file':
        return self.f_selectFile(self,ob=self,fmName=fmName,elName=elName,value=value,key=obj_attr['key'],lang=lang,manage_lang=manage_lang,REQUEST=REQUEST)
      
      #-- Password-Fields.
      if inputtype == 'password':
        size = obj_attr.get('size',20)
        return self.getPasswordInput(fmName,elName,size,value)
      
      #-- Dictionary/List-Fields.
      elif inputtype in ['dictionary','list']:
        css = 'form-fixed'
        if disabled: css += '-disabled'
        wrap = 'on'
        cols = 35
        rows = 1
        inp = []
        inp.append(self.getTextArea(fmName,elName,cols,rows,self.toXmlString(value),enabled,REQUEST,css,wrap))
        inp.append('<a href="javascript:f_open_input(\'%s\',\'%s\',\'form-fixed\',\'off\')">'%(fmName,elName))
        inp.append('<img src="%stable_cell_edit.gif" border="0" alt="%s" align="bottom">'%(self.MISC_ZMS,self.getLangStr('BTN_CHANGE',manage_lang)))
        inp.append('</a>')
        return ''.join(inp)
      
      #-- Text-Fields.
      elif inputtype in ['text','xml']:
        b = 0
        b = b or (inputtype in ['xml'])
        if hasattr(self,'getFormat'):
          textFrmt = self.getTextFormat(self.getFormat(REQUEST),REQUEST)
          b = b or (textFrmt is not None and not textFrmt.getTag() and not textFrmt.getSubTag())
        if b:
          css = 'form-fixed'
          wrap = 'off'
        else:
          css = 'form-element'
          wrap = 'on'
        if disabled: css += '-disabled'
        cols = obj_attr.get('size',40)
        if cols <= 40:
          rows = 5
        else:
          rows = 15
        extra = ' onselect="storeCaret(this)"'
        return self.getTextArea(fmName,elName,cols,rows,value,enabled,REQUEST,css,wrap,extra)
      
      #-- Boolean-Fields.
      elif inputtype == 'boolean':
        return self.getCheckbox(fmName,elName,value,enabled,0,REQUEST)
      
      #-- Select-Fields.
      elif inputtype in ['select','multiselect']:
        css = 'form-element'
        if disabled: css += '-disabled'
        lang_attr = obj_attr.get('label',obj_attr['key'])
        lang_display = self.getLangStr(lang_attr.upper(),manage_lang)
        if lang_display == lang_attr.upper():
          lang_display = lang_attr
        required = obj_attr.get('mandatory',0)
        optpl = self.getObjOptions(obj_attr,REQUEST)
        return self.getSelect(fmName,elName,value,inputtype,lang_display,required,optpl,enabled,REQUEST,css)
      
      #-- Input-Fields.
      else: 
        css = 'form-element'
        if disabled: css += '-disabled'
        if datatype in _globals.DT_DATETIMES:
          size = 12
          fmt_str = 'DATETIME_FMT'
          if datatype == _globals.DT_DATE:
            size = 8
            fmt_str = 'DATE_FMT'
          elif datatype == _globals.DT_TIME:
            size = 8
            fmt_str = 'TIME_FMT'
          return self.getDateTimeInput(fmName,elName,size,value,enabled,fmt_str,REQUEST,css)
        elif datatype == _globals.DT_URL:
          size = 22
          elTextName = ''
          return self.getUrlInput(fmName,elName,elTextName,size,value,enabled,REQUEST,css)
        else:
          size = 20
          if obj_attr.has_key('size'):
            size = obj_attr['size']
          elif datatype == _globals.DT_INT:
            size = 5
          elif datatype == _globals.DT_FLOAT:
            size = 8
          return self.getTextInput(fmName,elName,size,value,'text',enabled,REQUEST,css)

    # ---------------------------------------------------------------------------------------------
    #  ObjAttrs.getObjInput:
    # ---------------------------------------------------------------------------------------------
    def getObjInput(self, key, REQUEST):
      fmName = 'form0'
      meta_type = REQUEST.get('ZMS_INSERT',None)
      obj_attr = self.getObjAttr(key,meta_type)
      if meta_type is None:
        value = self.getObjAttrValue(obj_attr,REQUEST)
      elif obj_attr['key'] == 'active':
        value = 1
      elif obj_attr['key'] == 'attr_active_start':
        value = time.time()
      else:
        value = ''
      return self.getObjAttrInput(fmName,obj_attr,value,REQUEST)


    # ---------------------------------------------------------------------------------------------
    #  ObjAttrs.blob_html:
    # ---------------------------------------------------------------------------------------------
    def blob_html(self, key, REQUEST, RESPONSE):
      """ ObjAttrs.blob_html """
      if self.meta_type=='ZMSCustom' and self.getType()=='ZMSRecordSet':
        res = self.getObjProperty(self.getMetaobj(self.meta_id)['attrs'][0]['id'],REQUEST)
        i = key.rfind('_')
        sequence_index = int(key[i+1:])
        key = key[:i]
        obj_attr = self.getObjAttr(key)
        blob = res[sequence_index][key]
        blob = self.formatObjAttrValue(obj_attr,blob,REQUEST['lang'])
        RESPONSE.setHeader('Cache-Control','no-cache')
        RESPONSE.setHeader('Pragma','no-cache')
      else:
        blob = self.getObjProperty(key,REQUEST)
        RESPONSE.setHeader('Cache-Control','public, max-age=3600')
      return blob.blob_html(REQUEST,RESPONSE)


    # ---------------------------------------------------------------------------------------------
    #  ObjAttrs.hasObjProperty:
    #
    #  Checks if object has specified property.
    # ---------------------------------------------------------------------------------------------
    def hasObjProperty(self, key, REQUEST):

      #-- REQUEST
      lang = REQUEST.get('lang',self.getPrimaryLanguage())
      
      #-- DEFINITION
      obj_attr = self.getObjAttr(key)
      
      #-- OBJECT (Live / Work).
      ob = self.getObjVersion(REQUEST)
      
      #-- ATTR
      attr = self.getObjAttrName(obj_attr,lang)
      
      #-- Return if object has property (0=false, 1=true).
      return hasobjattr(ob,attr) and getattr(ob,attr,None) is not None


    """
    ###############################################################################################
    #
    #  Get
    #
    ###############################################################################################
    """

    # ---------------------------------------------------------------------------------------------
    #  ObjAttrs._getObjAttrValue:
    # ---------------------------------------------------------------------------------------------
    def _getObjAttrValue(self, obj_attr, obj_vers, lang):

      datatype = obj_attr['datatype_key']
      set, value = 0, getobjattr(self,obj_vers,obj_attr,lang)
      
      obj_default = _globals.dtMapping[datatype][1]
      
      #-- Blob-Fields
      if datatype in _globals.DT_BLOBS:
        if type(value) is type(''):
          set, value = 1, None
        elif value is not None:
          value = value._getCopy()
          value.aq_parent = self
          value.key = obj_attr['key']
          value.lang = lang

      #-- DateTime-Fields.
      elif datatype in _globals.DT_DATETIMES:
        if value is not None:
          if type(value) is type(''): 
            fmt_str = 'DATETIME_FMT'
            if datatype == _globals.DT_DATE:
              fmt_str = 'DATE_FMT'
            elif datatype == _globals.DT_TIME:
              fmt_str = 'TIME_FMT'
            set, value = 1, self.parseLangFmtDate(value)
          elif not type(value) is type(()): 
            set, value = 1, _globals.getDateTime(value)
      
      #-- List-Fields.
      elif datatype == _globals.DT_LIST:
        if not type(value) is type(obj_default):
          set, value = 1, [value]
      
      #-- Integer-Fields.
      elif datatype in _globals.DT_INTS and not type(value) is type(obj_default):
        try:
          set, value = 1, int(value)
        except:
          set, value = 1, obj_default
      
      #-- Float-Fields.
      elif datatype == _globals.DT_FLOAT and not type(value) is type(obj_default):
        try:
          set, value = 1, float(value)
        except:
          set, value = 1, obj_default
      
      #-- Url-Fields
      elif datatype == _globals.DT_URL:
        try:
          old = value
          ref_obj = self.getLinkObj(value)
          if ref_obj is not None:
            # Repair link.
            value = self.getRefObjPath(ref_obj)
          elif value.find('{$') == 0 and value.find('{$__') < 0:
            # Broken link.
            value = '{$__' + value[2:-1] + '__}'
          set = old != value
        except:
          _globals.writeException(self,'[_getObjAttrValue]: Unexpected Exception when processing Url-Fields: value=%s!'%str(value))
      
      #-- SET?
      if set: 
        attr = self.getObjAttrName(obj_attr,lang)
        #++ _globals.writeLog("[%s._getObjAttrValue]: setattr(%s,%s)"%(self.meta_type,attr,value))
        setattr(obj_vers,attr,value)
      
      # Return value.
      return value


    # ---------------------------------------------------------------------------------------------
    #  ObjAttrs.getObjAttrValue:
    # ---------------------------------------------------------------------------------------------
    def getObjAttrValue(self, obj_attr, REQUEST):
      datatype = obj_attr['datatype_key']
      obj_vers = self.getObjVersion(REQUEST)
      lang = REQUEST.get('lang',self.getPrimaryLanguage())
      while 1:
        value = self._getObjAttrValue(obj_attr,obj_vers,lang)
        empty = 0
        if obj_attr['multilang'] and \
           obj_attr['lang_inherit']:
          lang = self.getParentLanguage(lang)
          if lang is not None:
            empty = empty or (value is None)
            empty = empty or (datatype in _globals.DT_NUMBERS and obj_attr.has_key('default') and value==0)
            empty = empty or (datatype in _globals.DT_STRINGS and value=='')
            empty = empty or (datatype == _globals.DT_LIST and value==[])
        if not empty: break
      return value


    # ---------------------------------------------------------------------------------------------
    #  ObjAttrs.getObjProperty:
    #
    #  Retrieves value for specified property.
    # ---------------------------------------------------------------------------------------------
    def getObjProperty(self, key, REQUEST={}, par=None):
      
      #-- [ReqBuff]: Fetch buffered value from Http-Request.
      reqBuffId = '%s_%s'%('getObjProperty',key)
      try:
        if type(par) is type({}) and par.get('fetchReqBuff',1)==0:
          raise 'ReqBuff set inactive!'
        value = self.fetchReqBuff(reqBuffId,REQUEST)
        return value
      except:
        
        #-- Get value.
        obj_attr = self.getObjAttr(key)
        datatype = obj_attr['datatype_key']
        value = self.getObjAttrValue(obj_attr,REQUEST)
        
        #-- Process dtml.
        metaObjAttr = None
        if self.meta_type == 'ZMSCustom':
          metaObjAttr = self.getMetaobjAttr(self.meta_id,key)
        if metaObjAttr is not None and metaObjAttr['type']=='method':
          value = metaObjAttr.get('custom','')
          try:
            value = _globals.dt_html(self,value,REQUEST)
          except:
            value = _globals.writeException(self,'[getObjProperty]: key=%s'%key)
        elif metaObjAttr is not None and metaObjAttr['type']=='resource':
          value = metaObjAttr.get('custom',None)
          if value is not None:
            value = value._getCopy()
            value.aq_parent = self
            value.key = obj_attr['key']
            value.lang = self.getPrimaryLanguage()
        elif datatype == _globals.DT_TEXT:
          if type(value) is type('') and value.find('<dtml')>=0 and not self.getConfProperty('Demo.Active',0):
            try:
              value = _globals.dt_html(self,value,REQUEST)
            except:
              value = _globals.writeException(self,'[getObjProperty]: key=%s'%key)
        
        #-- [ReqBuff]: Returns value and stores it in buffer of Http-Request.
        return self.storeReqBuff(reqBuffId,value,REQUEST)


    """
    ###############################################################################################    
    ###  
    ###  Active
    ### 
    ###############################################################################################    
    """

    # -------------------------------------------------------------------------------------------------
    #  ObjAttrs.isActive:
    # -------------------------------------------------------------------------------------------------
    def isActive(self, REQUEST):
      b = 1
      obj_vers = self.getObjVersion(REQUEST)
      obj_attrs = self.getObjAttrs()
      for key in ['active','attr_active_start','attr_active_end']:
        if obj_attrs.has_key(key):
          obj_attr = obj_attrs[key]
          lang = REQUEST.get('lang',self.getPrimaryLanguage())
          while 1:
            value = self._getObjAttrValue(obj_attr,obj_vers,lang)
            empty = 0
            lang = self.getParentLanguage(lang)
            if lang is not None:
              empty = value is None
            if not empty: break
          # Toggle.
          if key == 'active':
            b = b and value
          # Start time.
          elif key == 'attr_active_start':
            if value is not None:
              dt = DateTime(time.mktime(value))
              b = b and dt.isPast()
          # End time.  
          elif key == 'attr_active_end':
            if value is not None:
              dt = DateTime(time.mktime(value))
              b = b and (dt.isFuture() or (dt.equalTo(dt.earliestTime()) and dt.latestTime().isFuture()))
          if not b: break
      return b


    """
    ###############################################################################################
    #
    #  Set
    #
    ###############################################################################################
    """
    
    # ---------------------------------------------------------------------------------------------
    #  ObjAttrs.formatObjAttrValue:
    # ---------------------------------------------------------------------------------------------
    def formatObjAttrValue(self, obj_attr, v, lang=None):
      
      #-- DATATYPE
      datatype = obj_attr['datatype_key']
      
      #-- VALUE
      if type(v) is type(''):
        v = v.strip()
        while len(v) > 0 and v[-1] == '\n':
          v = v[:-1]
      # Retrieve v from options.
      if obj_attr.has_key('options'):
        options = obj_attr['options']
        try: 
          i = options.index(int(v))
          if i%2==1: v = options[i-1]
        except:
          try:
            i = options.index(str(v))
            if i%2==1: v = options[i-1]
          except:
            pass
      
      #-- Blob-Fields
      if datatype in _globals.DT_BLOBS:
        if self.meta_type=='ZMSCustom' and self.getType()=='ZMSRecordSet' and \
           str(v) == str(_blobfields.createBlobField(self,datatype)):
          l = self.getObjProperty(self.getMetaobj(self.meta_id)['attrs'][0]['id'],REQUEST={'lang':lang,'preview':'preview'})
          r = filter(lambda x: x.get(obj_attr['key'],None)==v,l)
          v = v._getCopy()
          v.aq_parent = self
          v.key = '%s_%i'%(obj_attr['key'],l.index(r[0]))
          v.lang = lang
        if hasattr(v,'__class__') and getattr(v,'__class__') is ZPublisher.HTTPRequest.FileUpload:
          if len(getattr(v,'filename',''))==0:
            v = None
          else:
            v = _blobfields.createBlobField(self,datatype,v)
        if type(v) is type({}):
          if len(v.get('filename',None))==0:
            v = None
          else:
            v = _blobfields.createBlobField(self,datatype,v)
      
      #-- DateTime-Fields.
      elif datatype in _globals.DT_DATETIMES:
        if v is not None and type(v) is type(''):
          fmt_str = 'DATETIME_FMT'
          if datatype == _globals.DT_DATE:
            fmt_str = 'DATE_FMT'
          elif datatype == _globals.DT_TIME:
            fmt_str = 'TIME_FMT'
          v = self.parseLangFmtDate(v)
        v = _globals.getDateTime(v)
      
      #-- Dictionary-Fields
      elif datatype == _globals.DT_DICTIONARY:
        if v is None:
          v = {}
        if type(v) is type(''):
          try:
            v = self.parseXmlString(self.getXmlHeader() + v)
          except:
            pass
        if type(v) is type({}):
          v = v.copy()
      
      #-- List-Fields
      elif datatype == _globals.DT_LIST:
        if v is None:
          v = []
        if type(v) is type(''):
          try:
            l = self.parseXmlString(self.getXmlHeader() + v)
          except:
            l = None
          if l is not None:
            v = l
          else:
            v = [v.strip()]
        if type(v) is type([]):
          v = copy.copy(v) # copy.deepcopy(v)
      
      #-- Integer-Fields
      elif datatype in _globals.DT_INTS:
        if v is not None and type(v) is type('') and len(v) > 0:
          v = int(v)
      
      #-- Float-Fields
      elif datatype == _globals.DT_FLOAT:
        if v is not None and type(v) is type('') and len(v) > 0:
          v = float(v)
      
      #-- Password-Fields
      elif datatype == _globals.DT_PASSWORD:
        pass
        """
        if v is not None:
          v = self.encrypt_password(v)
        """
      
      #-- String-Fields.
      elif datatype in _globals.DT_STRINGS:
        if v is None:
          v = ''
        else:
          if type(v) is type(''):
            v = v.strip()
      
      #-- Text-Fields
      if datatype == _globals.DT_TEXT:
        i = -1
        c = 0
        while 1:
          i = v.find('{$',i+1)
          j = v.find('}',i+1)
          if i < 0 or j < 0:
            break
          ref_url = v[i:j+1]
          ref_obj = self.getLinkObj(ref_url)
          if ref_obj is not None:
            # Repair link.
            ref_url = self.getRefObjPath(ref_obj)
	    v = v[:i] + ref_url + v[j+1:]
	  elif ref_url.find('{$') == 0 and ref_url.find('{$__') < 0:
            # Broken link.
	    ref_url = '{$__' + ref_url[2:-1] + '__}'
	    v = v[:i] + ref_url + v[j+1:]
          c = c + 1
      
      #-- Url-Fields
      if datatype == _globals.DT_URL:
        ref_obj = self.getLinkObj(v)
        if ref_obj is not None:
          # Repair link.
          v = self.getRefObjPath(ref_obj)
        elif v.find('{$') == 0 and v.find('{$__') < 0:
          # Broken link.
          v = '{$__' + v[2:-1] + '__}'
      
      #++ _globals.writeLog("[%s.formatObjAttrValue] %s=%s"%(self.meta_type,obj_attr['key'],str(v)))
      return v


    # ---------------------------------------------------------------------------------------------
    #  setReqProperty:
    #
    #  Assigns value to specified property from Request-Object.
    # ---------------------------------------------------------------------------------------------
    def setReqProperty(self, key, REQUEST, forced=0):
    
      #-- REQUEST
      lang = REQUEST['lang']
      manage_lang = REQUEST['manage_lang']
      
      #-- DEFINTION
      obj_attr = self.getObjAttr(key)

      #-- ENABLED
      enabled = not self.isDisabledAttr(obj_attr,REQUEST)
      
      #-- DATATYPE
      datatype = obj_attr['datatype_key']
      
      #-- RETURN
      if not enabled or not obj_attr['xml'] or datatype == _globals.DT_UNKNOWN: 
        if not forced: 
          return
      
      #-- ATTR
      attr = self.getObjAttrName(obj_attr,lang)
      
      #-- VALUE
      set, value = 0, REQUEST.get(attr,None)
      
      #-- Blob-Fields
      if datatype in _globals.DT_BLOBS:
      
        # Image-Field (Dimensions)
        if datatype == _globals.DT_IMAGE:
          obj_vers = self.getObjVersion(REQUEST)
          img = self._getObjAttrValue(obj_attr,obj_vers,lang)
          if img is not None:
            if REQUEST.has_key('width_%s'%attr): 
              img.width = REQUEST['width_%s'%attr]
            if REQUEST.has_key('height_%s'%attr): 
              img.height = REQUEST['height_%s'%attr]
            self.setObjProperty(key,img,lang)
        
        # Delete
        if REQUEST.has_key('del_%s'%attr) and int(REQUEST['del_%s'%attr]) == 1:
          set, value = 1, None
        
        # Upload
        elif value is not None and len(getattr(value,'filename','')) > 0:
          set, value = 1, value
        
        # Reset
        elif REQUEST.get('ZMS_INSERT',None) is not None:
          set, value = 1, None
      
      #-- Integer-Fields
      elif datatype in _globals.DT_INTS:
        if value is not None:
          if type(value) == type('') and len(value) == 0:
            set, value = 1, None
          else:
            set, value = 1, int(value)
      
      #-- Float-Fields
      elif datatype == _globals.DT_FLOAT:
        if value is not None:
          if type(value) == type('') and len(value) == 0:
            set, value = 1, None
          else:
            set, value = 1, float(value)
      
      #-- Other-Fields
      else:
        set, value = 1, self.formatObjAttrValue(obj_attr,value,lang)

      #-- SET?
      if set: 
        #++ _globals.writeLog("[%s.setReqProperty] %s=%s"%(self.meta_type,key,str(value)))
        self.setObjProperty(key,value,lang)


    # ---------------------------------------------------------------------------------------------
    #  setObjProperty:
    #
    #  Assigns value to specified property.
    # ---------------------------------------------------------------------------------------------
    def setObjProperty(self, key, value, lang=None, forced=0):
    
      #-- [ReqBuff]: Clear buffered value from Http-Request.
      reqBuffId = '%s_%s'%('getObjProperty',key)
      self.clearReqBuff(reqBuffId,self.REQUEST)
    
      #-- DEFINITION
      obj_attr = self.getObjAttr(key)
      
      #-- DATATYPE
      datatype = obj_attr['datatype_key']
      
      #-- VALUE
      value = self.formatObjAttrValue(obj_attr,value,lang)
      
      #-- Text-Fields
      if datatype == _globals.DT_TEXT:
        # Unregister old references.
        req = {'lang' : lang, 'prevew' : 'preview'}
        old_value = self.getObjProperty(key,req)
        i = -1
        c = 0
        while 1:
          i = value.find('{$',i+1)
          j = value.find('}',i+1)
          if i < 0 or j < 0:
            break
          ref_url = value[i:j+1]
          ref_obj = self.getLinkObj(ref_url)
          if ref_obj is not None:
            ref_obj.unregisterRefObj(self, self.REQUEST)
          c = c + 1
        # Register new references.
        i = -1
        c = 0
        while 1:
          i = value.find('{$',i+1)
          j = value.find('}',i+1)
          if i < 0 or j < 0:
            break
          ref_url = value[i:j+1]
          ref_obj = self.getLinkObj(ref_url)
          if ref_obj is not None:
            ref_obj.registerRefObj(self, self.REQUEST)
            # Repair link.
            ref_url = self.getRefObjPath(ref_obj)
	    value = value[:i] + ref_url + value[j+1:]
	  elif ref_url.find('{$') == 0 and ref_url.find('{$__') < 0:
            # Broken link.
	    ref_url = '{$__' + ref_url[2:-1] + '__}'
	    value = value[:i] + ref_url + value[j+1:]
          c = c + 1
      
      #-- Url-Fields
      if datatype == _globals.DT_URL:
        # Unregister old reference.
        req = {'lang' : lang, 'prevew' : 'preview'}
        old_value = self.getObjProperty(key,req)
        ref_obj = self.getLinkObj(old_value)
        if ref_obj is not None:
          ref_obj.unregisterRefObj(self,self.REQUEST)
        # Register new reference.
        ref_obj = self.getLinkObj(value)
        if ref_obj is not None:
          ref_obj.registerRefObj(self,self.REQUEST)
          # Repair link.
          value = self.getRefObjPath(ref_obj)
        elif value.find('{$') == 0 and value.find('{$__') < 0:
          # Broken link.
          value = '{$__' + value[2:-1] + '__}'
      
      #-- SET!
      #++ _globals.writeLog("[%s.setObjProperty]: %s(%s)=%s"%(self.meta_type,key,str(datatype),str(value)))
      ob = self.getObjVersion({'preview':'preview'})
      setobjattr(self,ob,obj_attr,value,lang)
      if forced:
        ob = self.getObjVersion()
        setobjattr(self,ob,obj_attr,value,lang)


    """
    ###############################################################################################
    #
    #  C L O N E
    #
    ###############################################################################################
    """
    
    # ---------------------------------------------------------------------------------------------
    #  ObjAttrs.cloneObjAttrs:
    #
    #  Clone object-attributes.
    # ---------------------------------------------------------------------------------------------
    def cloneObjAttrs(self, src, dst, REQUEST={}):
    
      #-- REQUEST
      prim_lang = self.getPrimaryLanguage()
      lang = REQUEST.get('lang',prim_lang)
      
      #-- Clone
      keys = self.getObjAttrs().keys()
      if self.meta_type=='ZMSCustom' and self.getType()=='ZMSRecordSet':
        keys = ['sort_id','active',self.getMetaobjAttrIds(self.meta_id)[0]]
      for key in keys:
        obj_attr = self.getObjAttr(key)
        # Multi-Language Attributes.
        if obj_attr['multilang']:
          for s_lang in self.getLangIds():
            if lang in ['*',prim_lang,s_lang]:
              cloneobjattr(self,src,dst,obj_attr,s_lang)
        # Others.
        else:
          coverage = getattr(src,'attr_dc_coverage','')
          if coverage is None or coverage == '' or type(coverage) is not type(''): coverage = 'global.%s'%prim_lang
          s_lang = coverage[coverage.find('.')+1:]
          if lang in ['*',prim_lang,s_lang]:
            cloneobjattr(self,src,dst,obj_attr,lang)


###################################################################################################
###################################################################################################
###
###   O B J E C T   A T T R I B U T E S   M A N A G E R
###
###################################################################################################
###################################################################################################
class ObjAttrsManager:

    # ---------------------------------------------------------------------------------------------
    #	ObjAttrsManager.synchronizeObjAttrs:
    #
    #	Synchronizes object-attributes.
    # ---------------------------------------------------------------------------------------------
    def synchronizeObjAttrs(self):
      #++ if _globals.debug: print '[%s.synchronizeObjAttrs]'%(self.meta_type)

      datatypes = ['boolean','date','datetime','dictionary','file','float','identifier','image','int','list','multiselect','password','select','string','text','time','url','xml']
      self.dObjAttrs = {}
      for meta_type in self.dGlobalAttrs.keys():
        
        ##### Special Objects ####
        if meta_type == 'ZMSCustom':
          for meta_id in self.getMetaobjIds(sort=0):
            obj_attrs = self.dGlobalAttrs[meta_type]['obj_attrs'].copy()
            for key in self.getMetaobjAttrIds(meta_id):
              attr = self.getMetaobjAttr(meta_id,key)
              if attr['type'] in datatypes:
                dct = {}
                dct['xml'] = 1
                dct['key'] = attr['id']
                dct['label'] = attr['name']
                dct['type'] = attr['type']
                dct['datatype'] = attr['type']
                if attr['type'] == 'password':
                  dct['type'] = attr['type']
                  dct['datatype'] = 'string'
                elif attr['type'] == 'select':
                  dct['type'] = attr['type']
                  dct['datatype'] = 'string'
                elif attr['type'] == 'multiselect':
                  dct['type'] = attr['type']
                  dct['datatype'] = 'list'
                dct['mandatory'] = attr['mandatory']
                dct['multilang'] = attr['multilang']
                if len(attr['keys'])>0:
                  options = []
                  for option in attr['keys']:
                    options.append(option)
                    options.append(option)
                  dct['options'] = options
                obj_attrs[dct['key']] = dct
            self.dObjAttrs[meta_id] = obj_attrs
      
        ##### Standard Objects (Meta-Dictionaries) ####
        else:
          obj_attrs = self.dGlobalAttrs[meta_type]['obj_attrs'].copy()
          if obj_attrs.has_key('$metadict'):
            del obj_attrs['$metadict']
            for key in self.getMetadictAttrs(meta_type):
              attr = self.getMetadictAttr(key)
              if attr['type'] in datatypes:
                dct = {}
                dct['key'] = attr['key']
                dct['label'] = attr['name']
                dct['type'] = attr['type']
                dct['datatype'] = attr['type']
                if attr['type'] == 'password':
                  dct['type'] = attr['type']
                  dct['datatype'] = 'string'
                elif attr['type'] == 'select':
                  dct['type'] = attr['type']
                  dct['datatype'] = 'string'
                elif attr['type'] == 'multiselect':
                  dct['type'] = attr['type']
                  dct['datatype'] = 'list'
                dct['mandatory'] = attr['mandatory']
                dct['multilang'] = attr['multilang']
                if len(attr['keys'])>0:
                  options = []
                  for option in attr['keys']:
                    options.append(option)
                    options.append(option)
                  dct['options'] = options
                obj_attrs[dct['key']] = dct
          self.dObjAttrs[meta_type] = obj_attrs

      ##### Defaults ####
      for meta_type in self.dObjAttrs.keys():
        obj_attrs = self.dObjAttrs[meta_type]
        for key in obj_attrs.keys():
          obj_attr = obj_attrs[key]
          obj_attr['key'] = key
          obj_attr['xml'] = obj_attr.get('xml',1)
          obj_attr['datatype'] = obj_attr.get('datatype','string')
          obj_attr['mandatory'] = obj_attr.get('mandatory',0)
          obj_attr['multilang'] = obj_attr.get('multilang',0)
          obj_attr['lang_inherit'] = obj_attr.get('lang_inherit',1)
          #-- DATATYPE_KEY
          datatype = obj_attr['datatype'].lower()
          obj_attr['datatype_key'] = _globals.datatype_key(datatype)
          obj_attr['type'] = obj_attr.get('type',datatype)
          # Apply defaults.
          obj_attrs[key] = obj_attr
        self.dObjAttrs[meta_type] = obj_attrs
        
      return ''

###################################################################################################
