###################################################################################################
# _enummanager.py
#
# $Id: _enummanager.py,v 1.1 2003/10/11 15:10:04 zmsdev Exp $
# $Name:  $
# $Author: zmsdev $
# $Revision: 1.1 $
#
# Implementation of class EnumManager (see below).
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
from __future__ import nested_scopes
from App.Common import package_home
# Product Imports.
import _xmllib


###################################################################################################
###################################################################################################
###
###   class EnumManager
###
###################################################################################################
###################################################################################################
class EnumManager:

  # ------------------------------------------------------------------------------------------
  #  EnumManager.__init__:
  #
  #  Constructor
  # ------------------------------------------------------------------------------------------
  def __init__(self):
    pass
    
  # ------------------------------------------------------------------------------------------
  #  EnumManager.getValues:
  #
  #  Returns values for enumeration specified by Id.
  # ------------------------------------------------------------------------------------------
  getValues__roles__ = None
  def getValues(self, id, path=None):
    if path is None:
      path = package_home(globals())+'/import/'
    filename = path + 'enum.%s.xml'%id
    xml = open(filename)
    builder = _xmllib.XmlAttrBuilder()
    v = builder.parse(xml)
    xml.close()
    if type(v) is dict:
      l = map(lambda x: (v[x], x), v.keys())
      l.sort()
      v = []
      for i in l:
        v.extend([i[1],i[0]])
    return v

###################################################################################################
