###################################################################################################
# _zmsattributecontainer.py
#
# $Id: _zmsattributecontainer.py,v 1.2 2003/10/10 18:33:26 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.2 $
#
# Implementation of class ZMSAttributeContainer (see below).
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Documentation string.
__doc__ = """ZMS product module."""
# Version string. 
__version__ = '0.1' 

# Imports.
from Globals import HTMLFile, Persistent
from Acquisition import Implicit
from OFS.SimpleItem import Item
import AccessControl.Role
import urllib
import time
import string
# Product Imports.
import _objattrs
import _pathhandler


###################################################################################################
###################################################################################################
###   
###   C o n s t r u c t o r ( s )
###   
###################################################################################################
###################################################################################################
def manage_addZMSAttributeContainer(self):
  """ manage_addZMSAttributeContainer """
  id = str(time.time())
  while id in self.objectIds():
    id = str(time.time())
  obj = ZMSAttributeContainer(id)
  self._setObject(id,obj)
  obj = getattr(self,id)
  return obj


###################################################################################################
###################################################################################################
###
###   C l a s s
###
###################################################################################################
###################################################################################################
class ZMSAttributeContainer(
        Item,					# Item.
	Persistent,                     	# Persistent. 
	Implicit,                       	# Acquisition. 
	AccessControl.Role.RoleManager,	 	# Security manager.
	_objattrs.ObjAttrs,			# Object-Attributes.
	_pathhandler.PathHandler		# Path-Handler
	): 
	
  # Properties.
  # -----------
  meta_type = 'ZMSAttributeContainer'

  # Management Options.
  # -------------------
  manage_options = (  
	{'label': 'Attributes', 'action': 'manage_main'},
	) 

  # Management Interface.
  # ---------------------
  manage_main = HTMLFile('dtml/objattrs/manage_main', globals())
  

  # ---------------------------------------------------------------------------------------------
  #  ZMSAttributeContainer.getObjAttrs:
  #
  #  Overrides getObjAttrs of _objattrs.ObjAttrs.
  # ---------------------------------------------------------------------------------------------
  def getObjAttrs(self, meta_type=None):
    return self.aq_parent.getObjAttrs(meta_type)

  # ---------------------------------------------------------------------------------------------
  #  ZMSAttributeContainer.getObjVersion:
  #
  #  Overrides getObjVersion of _versionmanager.VersionManager.
  # ---------------------------------------------------------------------------------------------
  def getObjVersion(self, REQUEST={}):
    return self

  # ---------------------------------------------------------------------------------------------
  #  ZMSAttributeContainer.getChildNodes:
  # ---------------------------------------------------------------------------------------------
  def getChildNodes(self, REQUEST={}, meta_types=None):
    return []

  ###############################################################################################
  #  ZMSAttributeContainer.__init__: 
  #
  #  Constructor (initialise a new instance of ZMSAttributeContainer).
  ###############################################################################################
  def __init__(self, id): 
    """ ZMSAttributeContainer.__init__ """
    self.id = id

  
  ###############################################################################################
  #  ZMSAttributeContainer.manage_changeProperties: 
  #
  #  Change properties.
  ###############################################################################################
  def manage_changeProperties(self, REQUEST, RESPONSE): 
    """ ZMSAttributeContainer.manage_changeProperties """
    message = ''
    for key in self.getObjAttrs().keys():
      obj_attr=self.getObjAttr(key)
      if obj_attr['multilang']:
        for lang in self.getLangIds():
          REQUEST.set('lang',lang)
          REQUEST.set('manage_lang',self.getManageLanguage(lang))
          self.setReqProperty(key,REQUEST,1)
      else:
        REQUEST.set('lang',self.getPrimaryLanguage())
        REQUEST.set('manage_lang',self.getManageLanguage(lang))
        self.setReqProperty(key,REQUEST,1)
    # Return with message.
    return RESPONSE.redirect('manage_main?manage_tabs_message=%s'%(urllib.quote(message)))

###################################################################################################
