###################################################################################################
# zmscontainerobject.py
#
# $Id: zmscontainerobject.py,v 1.10 2004/11/24 20:54:37 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.10 $
#
# Implementation of class ZMSContainerObject (see below).
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
from __future__ import nested_scopes
from Globals import HTMLFile
import copy
import string 
import urllib
import time
# Product Imports.
from zmsobject import ZMSObject
from _metadata import Metadata
import zmsteaserelement
import _fileutil
import _globals
import _importable
import _objattrs
import _scormlib
import _versionmanager
import _ztrashcanclient


# ---------------------------------------------------------------------------------------------
#  zmscontainerobject.isPageWithElements:
# ---------------------------------------------------------------------------------------------
def isPageWithElements(obs):
  for ob in obs:
    if ob.isPageElement():
      return True
  return False


# ---------------------------------------------------------------------------------------------
#  zmscontainerobject.getPrevSibling: 
#
#  The node immediately preceding this node, otherwise returns None. 
# ---------------------------------------------------------------------------------------------
def getPrevSibling(self, REQUEST, management_interface=False):
  parent = self.getParentNode()
  if parent is not None:
    siblings = parent.getChildNodes(REQUEST,[self.PAGES,self.NORESOLVEREF]) 
    if self in siblings:
      i = siblings.index(self) - 1
      while i >= 0:
        ob = siblings[i]
        append = True
        append = append and (management_interface or (ob.isVisible(REQUEST) and not ob.isResource(REQUEST)))
        append = append and not (management_interface and ob.meta_type == 'ZMSLinkElement')
        if append:
          return ob
        i = i - 1
  return None

# ---------------------------------------------------------------------------------------------
#  zmscontainerobject.getNextSibling: 
#
#  The node immediately following this node, otherwise returns None. 
# ---------------------------------------------------------------------------------------------
def getNextSibling(self, REQUEST, management_interface=False):
  parent = self.getParentNode()
  if parent is not None:
    siblings = parent.getChildNodes(REQUEST,[self.PAGES,self.NORESOLVEREF]) 
    siblingIds = map( lambda x: x.id, siblings)
    if self.id in siblingIds:
      i = siblingIds.index( self.id) + 1
      while i < len(siblings):
        ob = siblings[i]
        append = True
        append = append and (management_interface or (ob.isVisible(REQUEST) and not ob.isResource(REQUEST)))
        append = append and not (management_interface and ob.meta_type == 'ZMSLinkElement')
        if append:
          return ob
        i = i + 1
  return None



###################################################################################################
###################################################################################################
###
###   A b s t r a c t   C l a s s
###
###   This is the abstract base class for all ZMS-Container Objects.
###
###################################################################################################
###################################################################################################
class ZMSContainerObject(
	ZMSObject, 
	Metadata, 
	_importable.Importable,
	_scormlib.SCORMLib,
	_versionmanager.VersionManagerContainer,
	_ztrashcanclient.ZTrashcanClient
	):

    # Management Permissions.
    # -----------------------
    __administratorPermissions__ = (
		'manage_system',
		)
    __ac_permissions__=(
		('ZMS Administrator', __administratorPermissions__),
		)

    # Interface.
    # ----------
    pageelement_TOC = HTMLFile('dtml/zmscontainerobject/pageelement_toc', globals())
    pageelement_Styleselect = HTMLFile('dtml/zmscontainerobject/pageelement_styleselect', globals())
    pageelement_Teaser = HTMLFile('dtml/zmsteasercontainer/pageelement_teaser', globals())
    bodyContent_Teaser = HTMLFile('dtml/zmsteasercontainer/pageelement_teaser', globals()) # DEPRECATED!
    
    # Management Interface.
    # ---------------------
    zmscontainerobject_input_js = HTMLFile('dtml/zmscontainerobject/input_js', globals()) # JavaScript
    zmslinkelement_input_js = HTMLFile('dtml/zmslinkelement/input_js', globals()) # JavaScript
    zmsfile_input_js = HTMLFile('dtml/zmsfile/input_js', globals()) # JavaScript
    main_js = HTMLFile('dtml/zmscontainerobject/main_js', globals()) # JavaScript
    manage_main = HTMLFile('dtml/zmscontainerobject/manage_main', globals()) 
    manage_main_btn = HTMLFile('dtml/zmscontainerobject/manage_main_btn', globals()) # Buttons
    manage_main_change = HTMLFile('dtml/zmscontainerobject/manage_main_change', globals()) # Change (Author & Date)
    manage_main_actions = HTMLFile('dtml/zmscontainerobject/manage_main_actions', globals()) # Actions
    manage_search = HTMLFile('dtml/zmscontainerobject/manage_search', globals()) 
    manage_properties = HTMLFile('dtml/zmscontainerobject/manage_properties', globals())
    manage_form = HTMLFile('dtml/zmscontainerobject/manage_form', globals())
    manage_system = HTMLFile('dtml/zmscontainerobject/manage_system', globals())
    manage_importexport = HTMLFile('dtml/zmscontainerobject/manage_importexport', globals()) 
    manage_importexportFtp = HTMLFile('dtml/zmscontainerobject/manage_importexportftp', globals()) 


    # Sitemap.
    # --------
    sitemap_tree = HTMLFile('dtml/zmscontainerobject/sitemap/tree', globals()) 
    sitemap_params = HTMLFile('dtml/zmscontainerobject/sitemap/params', globals()) 
    sitemap_layout0 = HTMLFile('dtml/zmscontainerobject/sitemap/version0', globals()) 
    sitemap_layout1 = HTMLFile('dtml/zmscontainerobject/sitemap/version1', globals()) 
    sitemap_layout2 = HTMLFile('dtml/zmscontainerobject/sitemap/version2', globals())


    # Role Manager.
    # -------------    
    def manage_addZMSCustom(self, meta_id, values={}, REQUEST=None):
      values['meta_id'] = meta_id
      return self.manage_addZMSObject('ZMSCustom',values,REQUEST)
    def manage_addZMSRubrik(self, values={}, REQUEST=None):
      return self.manage_addZMSObject('ZMSRubrik',values,REQUEST)
    def manage_addZMSDocument(self, values={}, REQUEST=None):
      return self.manage_addZMSObject('ZMSDocument',values,REQUEST)
    def manage_addZMSFile(self, values={}, REQUEST=None):
      return self.manage_addZMSObject('ZMSFile',values,REQUEST)
    def manage_addZMSGraphic(self, values={}, REQUEST=None):
      return self.manage_addZMSObject('ZMSGraphic',values,REQUEST)
    def manage_addZMSNote(self, values={}, REQUEST=None):
      return self.manage_addZMSObject('ZMSNote',values,REQUEST)
    def manage_addZMSLinkContainer(self, values={}, REQUEST=None):
      return self.manage_addZMSObject('ZMSLinkContainer',values,REQUEST)
    def manage_addZMSLinkElement(self, values={}, REQUEST=None):
      return self.manage_addZMSObject('ZMSLinkElement',values,REQUEST)
    def manage_addZMSSqlDb(self, values={}, REQUEST=None):
      return self.manage_addZMSObject('ZMSSqlDb',values,REQUEST)
    def manage_addZMSSysFolder(self, values={}, REQUEST=None):
      return self.manage_addZMSObject('ZMSSysFolder',values,REQUEST)
    def manage_addZMSTable(self, values={}, REQUEST=None):
      return self.manage_addZMSObject('ZMSTable',values,REQUEST)
    def manage_addZMSTeaserContainer(self, values={}, REQUEST=None):
      return self.manage_addZMSObject('ZMSTeaserContainer',values,REQUEST)
    def manage_addZMSTeaserElement(self, values={}, REQUEST=None):
      return self.manage_addZMSObject('ZMSTeaserElement',values,REQUEST)
    def manage_addZMSTextarea(self, values={}, REQUEST=None):
      return self.manage_addZMSObject('ZMSTextarea',values,REQUEST)

    # ---------------------------------------------------------------------------------------------
    #  ZMS.manage_addZMSObject:
    # ---------------------------------------------------------------------------------------------
    def manage_addZMSObject(self, meta_type, values, REQUEST):
      
      attrs = []
      for key in values.keys():
        attrs.extend([key,values[key]])
      
      # Get id.
      if 'id_prefix' in attrs:
        i = attrs.index('id_prefix')
        id_prefix = attrs[i+1]
        id = self.getNewId(id_prefix)
        del attrs[i] # Key.
        del attrs[i] # Value.
      elif 'id' in attrs:
        i = attrs.index('id')
        id = attrs[i+1]
        del attrs[i] # Key.
        del attrs[i] # Value.
      else:
        id = self.getNewId()
      
      # Get sort id.
      key = 'sort_id'
      if key in attrs and attrs.index(key)%2 == 0:
        i = attrs.index(key)
        sort_id = attrs[i+1]
        del attrs[i] # Key.
        del attrs[i] # Value.
      else:
        sort_id = 99999
      
      # Create new object.
      newNode = self.dGlobalAttrs[meta_type]['obj_class'](id,sort_id)
      self._setObject(newNode.id, newNode)
      node = getattr(self,newNode.id)
      
      # Init meta object.
      key = 'meta_id'
      if meta_type == 'ZMSCustom' and key in attrs and attrs.index(key)%2 == 0:
        i = attrs.index(key)
        meta_id = attrs[i+1]
        setattr(node,key,meta_id)
        del attrs[i] # Key.
        del attrs[i] # Value.
      
      # Object state.
      node.setObjStateNew(REQUEST)
      
      # Init properties.
      key = 'active'
      if not (key in attrs and attrs.index(key)%2 == 0):
        attrs.extend([key,1])
      for i in range(len(attrs)/2):
        key = attrs[i*2]
        value = attrs[i*2+1]
        node.setObjProperty(key,value,REQUEST['lang'])
      
      # Version manager.
      node.onChangeObj(REQUEST,forced=1)
      
      # Normalize sort-ids.
      self.normalizeSortIds(_globals.id_prefix(id))
      
      # Return object.
      return node


    # ------------------------------------------------------------------------------------------
    #  ZMSContainerObject.recurse_updateVersion:
    #
    #  Update version.
    # ------------------------------------------------------------------------------------------
    def recurse_updateVersion(self, REQUEST):
      message = ''
      
      # Process super-objects.
      message += ZMSObject.recurse_updateVersion(self,REQUEST)
      
      # Process object.
      # [...]
      
      # Recurse through child-nodes.
      for ob in self.objectValues(self.dGlobalAttrs.keys()):
        message += ob.recurse_updateVersion(REQUEST)
      
      # Return with message.
      return message


    """
    ###############################################################################################    
    ###
    ###   T r a s h c a n
    ###
    ###############################################################################################    
    """

    ###############################################################################################
    #  ZMSContainerObject.manage_eraseObjs:
    #
    #  Delete a subordinate object:
    #  The objects specified in 'ids' get deleted.
    ###############################################################################################
    def manage_eraseObjs(self, lang, manage_lang, ids, REQUEST, RESPONSE=None):
      """ ZMSContainerObject.manage_eraseObjs """ 
      message = ''
      t0 = time.time()
      
      ##### Delete objects ####
      count = len(ids)
      self.manage_delObjects(ids=ids)
      
      # Return with message.
      if RESPONSE is not None:
        message += self.getLangStr('MSG_DELETED',manage_lang)%count
        message += ' (in '+str(int((time.time()-t0)*100.0)/100.0)+' secs.)'
        target = REQUEST.get('target','manage_main')
        return RESPONSE.redirect('%s?lang=%s&manage_lang=%s&manage_tabs_message=%s'%(target,lang,manage_lang,urllib.quote(message)))


    ###############################################################################################
    #  ZMSContainerObject.manage_deleteObjs:
    #
    #  Delete a subordinate object:
    #  The objects specified in 'ids' get deleted.
    ###############################################################################################
    def manage_deleteObjs(self, lang, manage_lang, ids, REQUEST, RESPONSE=None):
      """ ZMSContainerObject.manage_deleteObjs """ 
      message = ''
      t0 = time.time()
      
      ##### Delete objects ####
      for child in self.getChildNodes():
        if child.id in ids:
          child.setObjStateDeleted(REQUEST)
      
      ##### VersionManager ####
      self.onChangeObj(REQUEST)
      
      # Return with message.
      if RESPONSE is not None:
        message += self.getLangStr('MSG_TRASHED',manage_lang)%len(ids)
        message += ' (in '+str(int((time.time()-t0)*100.0)/100.0)+' secs.)'
        target = REQUEST.get('target','manage_main')
        return RESPONSE.redirect('%s?preview=preview&lang=%s&manage_lang=%s&manage_tabs_message=%s'%(target,lang,manage_lang,urllib.quote(message)))


    """
    ###############################################################################################    
    ###
    ###   P r o p e r t i e s
    ###
    ###############################################################################################    
    """

    ###############################################################################################
    #  ZMSContainerObject.manage_changeProperties: 
    #
    #  Change properties.
    ###############################################################################################
    def manage_changeProperties(self, lang, manage_lang, REQUEST=None): 
      """ ZMSContainerObject.manage_changeProperties """
      
      target = REQUEST.get( 'target', 'manage_main')
      message = ''
      
      if REQUEST.get('btn','') != self.getLangStr('BTN_CANCEL',manage_lang):
        
        ##### Object State #####
        self.setObjStateModified(REQUEST)
        
        ##### Properties #####
        root = self.getHome()
        # Title.
        self.setReqProperty('title',REQUEST)
        self.setReqProperty('titleshort',REQUEST)
        self.setReqProperty('titleimage',REQUEST)
        # Active.
        self.setReqProperty('active',REQUEST)
        self.setReqProperty('attr_active_start',REQUEST)
        self.setReqProperty('attr_active_end',REQUEST)
        # Levelnfc
        if 'levelnfc' in self.getObjAttrs().keys():
          self.setReqProperty('levelnfc',REQUEST)
        # Cacheable
        if REQUEST['AUTHENTICATED_USER'].has_permission('ZMS Administrator',self) and \
           'attr_cacheable' in self.getObjAttrs().keys() and self.getConfProperty('ZMS.cache.active')==1:
          self.setReqProperty('attr_cacheable',REQUEST)
        
        ##### Metadata #####
        self.setMetadata(lang,manage_lang,REQUEST)
        
        ##### VersionManager ####
        self.onChangeObj(REQUEST)
      
      # Return with message.
      message = self.getLangStr('MSG_CHANGED',manage_lang)
      if REQUEST and hasattr(REQUEST,'RESPONSE'):
        if REQUEST.RESPONSE:
          RESPONSE = REQUEST.RESPONSE
          target = self.url_append_params( target, { 'lang': lang, 'manage_lang': manage_lang, 'preview': 'preview', 'manage_tabs_message': message})
          target = '%s#_%s'%( target, self.id)
          return RESPONSE.redirect( target)


    # -------------------------------------------------------------------------------------------------
    #	ZMSContainerObject.isPage:
    # -------------------------------------------------------------------------------------------------
    def isPage( self): 
      return True


    # ---------------------------------------------------------------------------------------------
    #  ZMSContainerObject.getLevelnfc
    # ---------------------------------------------------------------------------------------------
    def _getLevelnfc(self, REQUEST):
      s = ''
      if self.getLevel() > 0:
        parent = self.getParentNode()
        if hasattr(parent,'_getLevelnfc') and parent.getLevel() < self.getLevel():
          s = parent._getLevelnfc(REQUEST)
        levelnfc = parent.getObjProperty('levelnfc',REQUEST)
        if len(levelnfc) > 0:
          siblings = parent.filteredChildNodes(REQUEST,self.PAGES)
          if self in siblings:
            i = siblings.index(self)
            if levelnfc == '0':
              s += str(i + 1) + '.'        
            elif levelnfc == '1':
              s += chr(i + ord('A')) + '.'
            elif levelnfc == '2':
              s += chr(i + ord('a')) + '.'
      return s

    def getLevelnfc(self, REQUEST):
      s = ''
      if self.getLevel() > 0:
        parent = self.getParentNode()
        if parent is not None:
          levelnfc = parent.getObjProperty('levelnfc',REQUEST)
          if len(levelnfc) > 0:
            s = self._getLevelnfc(REQUEST)
            if len(s) > 0: s += ' '
      return s


    # ---------------------------------------------------------------------------------------------
    #  ZMSContainerObject.getTitle
    # ---------------------------------------------------------------------------------------------
    def getTitle( self, REQUEST): 
      title = self.getLevelnfc(REQUEST) + self.getObjProperty('title',REQUEST)
      if len(title) == 0: title = self.display_type(REQUEST)
      return title


    # ---------------------------------------------------------------------------------------------
    #  ZMSContainerObject.getTitlealt
    # ---------------------------------------------------------------------------------------------
    def getTitlealt( self, REQUEST): 
      titlealt = self.getLevelnfc(REQUEST) + self.getObjProperty('titleshort',REQUEST)
      if len(titlealt) == 0: titlealt = self.display_type(REQUEST)
      return titlealt


    # ---------------------------------------------------------------------------------------------
    #  ZMSContainerObject.getTitleimage
    # ---------------------------------------------------------------------------------------------
    def getTitleimage( self, REQUEST): 
      return self.getObjProperty('titleimage',REQUEST) 


    # ---------------------------------------------------------------------------------------------
    #  ZMSContainerObject.getContentType
    # ---------------------------------------------------------------------------------------------
    def getContentType( self, REQUEST): 
      return 'text/html'


    """
    ###############################################################################################    
    ###
    ###   P a g e - N a v i g a t i o n
    ###
    ###############################################################################################    
    """

    # -------------------------------------------------------------------------------------------------
    #  ZMSContainerObject.getFirstPage:
    # -------------------------------------------------------------------------------------------------
    def getFirstPage(self, REQUEST, root=None, meta_types=None, deep=0): 
      ob = None
      root = _globals.nvl(root,self.getDocumentElement())
      meta_types = _globals.nvl(meta_types,self.PAGES)
      ob = root
      return root
    
    # -------------------------------------------------------------------------------------------------
    #  ZMSContainerObject.getPrevPage:
    # -------------------------------------------------------------------------------------------------
    def getPrevPage(self, REQUEST, root=None, meta_types=None, deep=0): 
      ob = None
      root = _globals.nvl(root,self.getDocumentElement())
      meta_types = _globals.nvl(meta_types,self.PAGES)
      while 1:
        ob = getPrevSibling(self,REQUEST)
        if ob is None:
          parent = self.getParentNode()
          if parent is not None:
            ob = parent.getPrevPage(REQUEST,root,meta_types,deep)
        else:
          ob = ob.getLastPage(REQUEST,ob,meta_types,deep)
        if not ob is None and not ob.isMetaType(meta_types,REQUEST):
          ob = ob.getPrevPage(REQUEST,root,meta_types,deep)
        if ob is None or ob.isMetaType(meta_types,REQUEST):
          break;
      return ob

    # -------------------------------------------------------------------------------------------------
    #  ZMSContainerObject.getNextPage:
    # -------------------------------------------------------------------------------------------------
    def getNextPage(self, REQUEST, root=None, meta_types=None, deep=0): 
      ob = None
      root = _globals.nvl(root,self.getDocumentElement())
      meta_types = _globals.nvl(meta_types,self.PAGES)
      while 1:
        children = self.filteredChildNodes(REQUEST,self.PAGES)
        if len(children) > 0:
          ob = children[0]
        else:
          current = self
          while ob is None and current is not None:
            ob = getNextSibling(current,REQUEST)
            current = current.getParentNode()
        if not ob is None and not ob.isMetaType(meta_types,REQUEST):
          ob = ob.getNextPage(REQUEST,root,meta_types,deep)
        if ob is None or ob.isMetaType(meta_types,REQUEST):
          break;
      return ob

    # -------------------------------------------------------------------------------------------------
    #  ZMSContainerObject.getLastPage:
    # -------------------------------------------------------------------------------------------------
    def getLastPage(self, REQUEST, root=None, meta_types=None, deep=0): 
      ob = None
      root = _globals.nvl(root,self.getDocumentElement())
      meta_types = _globals.nvl(meta_types,self.PAGES)
      children = [root]
      while len(children) > 0:
        i = len(children)-1
        while i>=0:
          if not children[i].isResource(REQUEST):
            ob = children[i]
            i=0
          i=i-1
        children = ob.filteredChildNodes(REQUEST,self.PAGES)
      return ob



    """
    ###############################################################################################
    ###
    ###  Related Links 
    ###
    ###############################################################################################
    """

    # ---------------------------------------------------------------------------------------------
    #  ZMSContainerObject.getLinkList:
    #
    #  Returns list of link-URLs for child-objects.
    # ---------------------------------------------------------------------------------------------
    def getLinkList(self, REQUEST, allow_none=0):
      
      #-- [ReqBuff]: Fetch buffered value from Http-Request.
      try:
        reqBuffId = 'getLinkList%i'%allow_none
        value = self.fetchReqBuff(reqBuffId,REQUEST)
        return value
      except:
        
        #-- Get value.
        value = []
        for ob in self.filteredChildNodes(REQUEST,['ZMSFile','ZMSLinkContainer','ZMSLinkElement']):
          if not ob.meta_type=='ZMSLinkElement' or \
             not ob.isPage() or \
             not ob.getObjProperty('attr_type',REQUEST)=='embed':
            value.extend(ob.getLinkList(REQUEST,allow_none))
        
        #-- [ReqBuff]: Returns value and stores it in buffer of Http-Request.
        return self.storeReqBuff(reqBuffId,value,REQUEST)


    """
    ###############################################################################################    
    ###  
    ###  Object-actions of management interface
    ### 
    ###############################################################################################    
    """

    # ---------------------------------------------------------------------------------------------
    #  ZMSContainerObject.filtered_metapattern_actions:
    # ---------------------------------------------------------------------------------------------
    def filtered_metapattern_actions(self, path, REQUEST):
      actions = []
      lang = REQUEST['lang']
      manage_lang = REQUEST['manage_lang']
      auth_user = REQUEST['AUTHENTICATED_USER']
      
      # Meta-Patterns.
      # --------------
      if self.meta_type != 'ZMSTrashcan':
        meta_patterns = []
        for id in self.getMetapatternIds(REQUEST):
          record = (self.getMetapatternTitle(id,REQUEST),'manage_instantiateMetapattern',[])
          if not record in meta_patterns:
            meta_patterns.append(record)
        # Sort.
        meta_patterns.sort()
        # Add.
        record = (self.getLangStr('ACTION_INSERT_METAPATTERN',manage_lang),path + 'manage_addMetapatternForm',[])
        if ((self.getLevel()) > 0 or (len(path) > 0 and hasattr(self,path[:-1]) and getattr(self,path[:-1]).isPage())) and \
           self.isPage() and \
           auth_user.has_permission('ZMS Administrator',self):
          meta_patterns.append(record)
        # Heading.
        if len(meta_patterns) > 0:
          actions.append((self.getLangStr('CAPTION_INSERT', manage_lang)%self.getLangStr('TAB_METAPATTERN',manage_lang),'',meta_patterns))
      
      # Return action list.
      return actions


    # ---------------------------------------------------------------------------------------------
    #  ZMSContainerObject.filtered_insert_actions:
    # ---------------------------------------------------------------------------------------------
    def filtered_insert_actions(self, path, REQUEST):
      rtn = []
      lang = REQUEST['lang']
      manage_lang = REQUEST['manage_lang']
      auth_user = REQUEST['AUTHENTICATED_USER']
      
      #-- From Cache.
      if REQUEST.has_key('ZMS_FILTERED_INSERT_ACTIONS'):
        actions = REQUEST.get('ZMS_FILTERED_INSERT_ACTIONS')
      
      else:
        
        # ZMS-Objects.
        # ------------
        actions = []
        for ac_inherited_permission in self.ac_inherited_permissions(1):
          ac_permission = ac_inherited_permission[0]
          ac_actions = ac_inherited_permission[1]
          for ac_action in list(ac_actions):
            if ac_action.find('manage_addZMS')==0:
              meta_type = ac_action[10:]
              if self.getConfProperty('%s.enabled'%meta_type,1)==1:
                constructor = self.dGlobalAttrs[meta_type]['constructor']
                if constructor is not None:
                  record = (self.display_type(REQUEST,meta_type),'manage_addProduct/zms/%s'%self.dGlobalAttrs[meta_type]['constructor'],[])
                  if not record in actions:
                    actions.append(record)
        # Sort.
        actions.sort()
        
        # Meta-Objects.
        # -------------
        metaObjs = []
        for meta_id in self.getMetaobjIds():
          ob = self.getMetaobj(meta_id)
          if (self.getConfProperty('%s.enabled'%meta_id,1) == 1) and \
             ((ob.get( 'access') is None) or (len( self.intersection_list( self.concat_list( ob.get( 'access').get( 'insert'), [ 'Manager']), self.getUserRoles(auth_user))) > 0)):
            if (self.meta_type in ['ZMS','ZMSRubrik'] and ob['type'] in ['ZMSDocument','ZMSObject','ZMSResource','ZMSRecordSet','ZMSReference']) or \
               (self.meta_type in ['ZMSDocument'] and ob['type'] in ['ZMSObject','ZMSResource','ZMSRecordSet']) or \
               (self.meta_type in ['ZMSTeaserContainer'] and ob['type'] in ['ZMSTeaserElement']):
              record = (ob['name'],'manage_addProduct/zms/manage_addzmscustomform',[])
              if not record in metaObjs:
                metaObjs.append(record)
        # Sort.
        metaObjs.sort()
        # Heading.
        if len(metaObjs) > 0:
          actions.append((self.getLangStr('CAPTION_INSERT',manage_lang)%self.getLangStr('TAB_METAOBJ',manage_lang),'',metaObjs))
        
        #-- To Cache.
        REQUEST.set('ZMS_FILTERED_INSERT_ACTIONS', actions)
      
      # Meta-Patterns.
      # --------------
      actions = copy.deepcopy(actions)
      actions.extend(self.filtered_metapattern_actions(path, REQUEST))
      
      # Heading
      if len(actions) > 0:
        rtn.append((self.getLangStr('ACTION_INSERT', manage_lang)%self.display_type(REQUEST), '', actions ))
      
      # Return action list.
      return rtn


    # ---------------------------------------------------------------------------------------------
    #  ZMSContainerObject.filtered_container_actions:
    # ---------------------------------------------------------------------------------------------
    def filtered_container_actions(self, REQUEST):
      rtn = []
      
      path = ''
      lang = REQUEST['lang']
      manage_lang = REQUEST['manage_lang']
      auth_user = REQUEST['AUTHENTICATED_USER']
      
      #-- WORKFLOW
      actions = self.filtered_workflow_actions(path,REQUEST)
      if len(actions) > 0:
        rtn.append((self.getLangStr('ATTR_CHANGES',manage_lang),'',actions))
      
      #-- COMMANDS
      actions = self.filtered_command_actions(path,REQUEST)
      if len(actions) > 0:
        rtn.append((self.getLangStr('ACTION_SELECT',manage_lang)%self.getLangStr('ATTR_ACTION',manage_lang),'',actions))
      
      #-- INSERT
      rtn.extend(self.filtered_insert_actions(path,REQUEST))
     
      # Return action list.
      return rtn


    """
    ###############################################################################################
    ###
    ###  H T M L - P r e s e n t a t i o n 
    ###
    ###############################################################################################
    """

    # ---------------------------------------------------------------------------------------------
    #  ZMSContainerObject.getPageSiblingMapping:
    #
    #  Mapping of the pages immediately preceding this page, otherwise returns empty list. 
    # ---------------------------------------------------------------------------------------------
    def getPageSiblingMapping(self, obs, REQUEST, management_interface=False):
      dct = {}
      for ob in obs:
        dct[ob.id] = getNextSibling(ob,REQUEST,management_interface)
      return dct

    # ---------------------------------------------------------------------------------------------
    #  ZMSContainerObject.getSitemapElements: 
    #
    #  Elemente der Sitemap
    # ---------------------------------------------------------------------------------------------
    def getSitemapElements(self, REQUEST, expand_default=2, management_interface=False, current=None):
      elmnts = []
      # Retrieve elements.
      if current is None:
        elmnts.extend(self.getDocumentElement().getSitemapElements(REQUEST,expand_default,management_interface,self))
      else:
        append = True
        append = append and (self.isPage())
        append = append and (management_interface or self.isVisible(REQUEST)) # Object is visible.
        append = append and (management_interface or not self.isResource(REQUEST)) # Object is not resource.
        append = append and not (management_interface and self.meta_type == 'ZMSLinkElement')
        if append: 
          elmnts.append(self)
          # Child navigation.
          if self.getLevel() < expand_default or self.isAnchestor(current):
            for ob in self.getChildNodes(REQUEST,[self.PAGES,self.NORESOLVEREF]):
              elmnts.extend(ob.getSitemapElements(REQUEST,expand_default,management_interface,current))
      # Return elements.
      return elmnts


    # ---------------------------------------------------------------------------------------------
    #  ZMSContainerObject.getNavElements: 
    #
    #  Elemente der Hauptnavigation im Contentbereich
    # ---------------------------------------------------------------------------------------------
    def getNavElements(self, REQUEST, expand_tree=1, current_child=None, subElements=[]):
      elmnts = []
      # Child navigation.
      obs = self.filteredChildNodes(REQUEST)
      if not expand_tree and \
         current_child is not None and \
         current_child.meta_type not in ['ZMSDocument','ZMSCustom'] and \
         isPageWithElements(obs) and \
         self.getLevel() > 0:
        obs = [current_child]
      for ob in obs:
        append = True
        append = append and (ob.isPage())
        append = append and (not ob.isResource(REQUEST)) # Object is not resource.
        if append: elmnts.append(ob)
        if current_child is not None and \
           ob.id == current_child.id:
          elmnts.extend(subElements)
      # Parent navigation.
      parent = self.getParentNode()
      if parent is not None:
        elmnts = parent.getNavElements(REQUEST,expand_tree,self,elmnts)
      # Return elements.
      return elmnts


    # ---------------------------------------------------------------------------------------------
    #  ZMSContainerObject.getIndexNavElements: 
    #
    #  Elemente der Index-Navigation im Contentbereich
    # ---------------------------------------------------------------------------------------------
    def getIndexNavElements(self, REQUEST):
      indexNavElmnts = []
      # Retrieve elements.
      if REQUEST.get('op','')=='':
        indexNavElmnts = filter(lambda ob: ob.isPage() and ob.isMetaType(['ZMSDocument','ZMSCustom']) and not ob.isResource(REQUEST),self.filteredChildNodes(REQUEST,self.PAGES))
      # Return elements.
      return indexNavElmnts


    # ---------------------------------------------------------------------------------------------
    #  ZMSContainerObject.renderShort:
    #
    #  Renders short presentation of a ContainerObject.
    # ---------------------------------------------------------------------------------------------
    def renderShort(self,REQUEST):
      return '<h2>%s</h2>'%self.getTitlealt(REQUEST)


    # ---------------------------------------------------------------------------------------------
    #  ZMSContainerObject.printHtml:
    #
    #  Renders print presentation of a ContainerObject.
    # ---------------------------------------------------------------------------------------------
    def printHtml(self, level, sectionizer, REQUEST, deep=True):
      html = ''
      
      # Title.
      sectionizer.processLevel( level)
      title = self.getTitle( REQUEST)
      title = '%s %s'%(str(sectionizer),title)
      REQUEST.set( 'ZMS_SECTIONIZED_TITLE', '<h%i>%s</h%i>'%( level, title, level))
      
      # pageregionBefore
      attr = REQUEST.get( 'ZMS_PAGEREGION_BEFORE', 'pageregionBefore')
      if hasattr( self, attr):
        html += getattr( self, attr)( self, REQUEST)
      elif hasattr( self, 'bodyContent_PagePre'):
        html += getattr( self, 'bodyContent_PagePre')( self,REQUEST)
    
      # bodyContent
      subsectionizer = {}
      for ob in self.filteredChildNodes( REQUEST, self.PAGEELEMENTS):
        if not subsectionizer.has_key( ob.meta_type):
          subsectionizer[ob.meta_type] = sectionizer.clone()
        subsectionizer[ob.meta_type].processLevel(level+1)
        html += ob.printHtml( level+1, subsectionizer[ob.meta_type], REQUEST)
      
      # pageregionAfter
      attr = REQUEST.get( 'ZMS_PAGEREGION_AFTER', 'pageregionAfter')
      if hasattr( self, attr):
        html += getattr( self, attr)( self, REQUEST)
      elif hasattr( self ,'bodyContent_PagePost'):
        html += getattr( self ,'bodyContent_PagePost')( self,REQUEST)
      
      # Container-Objects.
      if deep:
        for ob in self.filteredChildNodes(REQUEST,self.PAGES):
          html += ob.printHtml( level+1, sectionizer, REQUEST, deep)
      
      return html


    """
    ###############################################################################################    
    ###  
    ###  DOM-Methoden 
    ### 
    ###############################################################################################    
    """

    # ---------------------------------------------------------------------------------------------
    #  ZMSContainerObject.filteredTreeNodes:
    #
    #  Returns a NodeList that contains all accessible children of this subtree in correct order.
    #  If none, this is a empty NodeList. 
    # ---------------------------------------------------------------------------------------------
    def filteredTreeNodes(self, REQUEST, meta_types, order_by=None, order_dir='asc', max_len=None):
      rtn = []
      
      #-- Process tree.
      obs = self.getChildNodes(REQUEST)
      for ob in obs:
        append = True
        append = append and ob.isMetaType(meta_types)
        append = append and ob.isVisible(REQUEST)
        if append: rtn.append(ob)
        if ob.isPage():
          rtn.extend(ob.filteredTreeNodes(REQUEST,meta_types))
      
      #-- Order.
      if order_by is not None:
      
        # order by select-options of special object
        options = []
        if type(meta_types) is type('') and meta_types in self.getMetaobjIds():
          metaObj = self.getMetaobj(meta_types)
          attrs = metaObj['attrs']
          for attr in attrs:
            if attr['id'] == order_by:
              options = attr.get('keys',[])
      
        # collect object-items
        tmp = []
        for ob in rtn:
          value = ob.getObjProperty(order_by,REQUEST)
          if value in options:
            value = options.index(value)
          tmp.append((value,ob))
        
        # sort object-items
        tmp.sort()
        
        # truncate sort-id from sorted object-items
        rtn = map(lambda ob: ob[1],tmp)
        if order_dir=="desc": rtn.reverse()
      
      #-- Size.
      if max_len is not None:
        if len(rtn) > max_len:
          rtn = rtn[:max_len]
      
      return rtn

    # ---------------------------------------------------------------------------------------------
    #  ZMSContainerObject.firstFilteredChildNode:
    #
    #  Returns the first accessible child of this node.
    # ---------------------------------------------------------------------------------------------
    def firstFilteredChildNode(self, REQUEST={}, meta_types=None, management_interface=False):
      for node in self.getChildNodes(REQUEST,meta_types):
        if management_interface or node.isVisible(REQUEST):
          return node
      return None

    # ---------------------------------------------------------------------------------------------
    #  ZMSContainerObject.filteredChildNodes:
    #
    #  Returns a NodeList that contains all accessible children of this node in correct order.
    #  If none, this is a empty NodeList. 
    # ---------------------------------------------------------------------------------------------
    def filteredChildNodes(self, REQUEST={}, meta_types=None, management_interface=False):
      return filter(lambda ob: management_interface or ob.isVisible(REQUEST),self.getChildNodes(REQUEST,meta_types))

    # ---------------------------------------------------------------------------------------------
    #  ZMSContainerObject.getChildNodes:
    #
    #  Returns a NodeList that contains all children of this node in correct order.
    #  If none, this is a empty NodeList. 
    # ---------------------------------------------------------------------------------------------
    def getChildNodes(self, REQUEST={}, meta_types=None):
    
      # Collect Object-Items.
      lang = REQUEST.get('lang',None)
      coverages = []
      if lang is not None:
        coverages.extend(['global.'+lang,'local.'+lang])
        for parent in self.getParentLanguages(lang):
          coverages.append('global.'+parent)
      obs = []
      key_coverage = 'attr_dc_coverage'
      key_sort = 'sort_id'
      prim_lang = self.getPrimaryLanguage()
      for ob in self.objectValues(filter(lambda x: x!='ZMSTrashcan',self.dGlobalAttrs.keys())):
        if ob.isMetaType(meta_types,REQUEST):
          obj_vers = ob.getObjVersion(REQUEST)
          coverage = ''
          if _objattrs.hasobjattr(obj_vers,key_coverage):
            coverage = getattr(obj_vers,key_coverage,coverage)
          if coverage in [ '', None]: coverage = 'global.' + prim_lang
          if lang is None or coverage in coverages:
            proxy = ob.__proxy__()
            if proxy is not None:
              sort = getattr(obj_vers,key_sort,'')
              if proxy.isPage(): sort = 's%s'%sort
              obs.append((sort,proxy))
      
      # Sort child-nodes.
      obs.sort()
      
      # Return child-nodes in correct sort-order.
      return map(lambda ob: ob[1],obs)


    """
    ###############################################################################################    
    ###  
    ###  Sort-Order
    ### 
    ###############################################################################################    
    """

    # ---------------------------------------------------------------------------------------------
    #  ZMSContainerObject.normalizeSortIds:
    #
    #  Normalizes Sort-IDs of a ZMSContainerObject's elements.
    # ---------------------------------------------------------------------------------------------
    def normalizeSortIds(self, id_prefix='e'):
      sort_id = 10
      for ob in self.getChildNodes():
       if ob.id[:len(id_prefix)] == id_prefix:
         ob.setSortId(sort_id)
         sort_id = sort_id + 10


    # ---------------------------------------------------------------------------------------------
    #  ZMSContainerObject.getNewSortId:
    #
    #  Get new Sort-ID.
    # ---------------------------------------------------------------------------------------------
    def getNewSortId(self):
      req = {'lang':self.getPrimaryLanguage(),'preview':'preview'}
      new_sort_id = 0
      for ob in self.getChildNodes({'preview':'preview'}):
        sort_id = ob.getSortId(req)
        if sort_id > new_sort_id:
          new_sort_id = sort_id
      new_sort_id = new_sort_id + 10
      return new_sort_id


    """
    ###############################################################################################    
    #
    #   Teaser
    #
    ###############################################################################################    
    """

    # ---------------------------------------------------------------------------------------------
    #  ZMSContainerObject.getTeaserElements:
    #
    #  Returns Teaser-Objects.
    # ---------------------------------------------------------------------------------------------
    def getTeaserElements(self, REQUEST, current=None):
      teaserElmnts = []
      # Retrieve elements.
      current = _globals.nvl(current,self)
      # Process parent.
      abort = current.getObjProperty('attr_zmsteasercontainer_abort_penetrance',REQUEST)
      if abort == '':
        parent = self.getParentNode()
        if parent is not None:
          teaserElmnts.extend(parent.getTeaserElements(REQUEST,current))
      # Process this.
      thisTeaserElmnts = filter( lambda x: x.getType() == 'ZMSTeaserElement', self.filteredChildNodes( REQUEST,[ 'ZMSCustom']))
      for teaserCntnr in self.filteredChildNodes( REQUEST,[ 'ZMSTeaserContainer']):
        thisTeaserElmnts.extend( teaserCntnr.filteredChildNodes( REQUEST,[ 'ZMSTeaserElement', 'ZMSCustom']))
      for teaserElmnt in thisTeaserElmnts:
          #-- Penetrance
          penetrance = teaserElmnt.getPenetrance(REQUEST)
          append = False
          # 0= this 
          append = append or (penetrance == 0 and current == self)
          # 1= sub_nav
          append = append or (penetrance == 1 and current.isMetaType(['ZMS','ZMSRubrik'],REQUEST))
          # 2= sub_all
          append = append or (penetrance == 2)
          #-- Append
          if append: teaserElmnts.append(teaserElmnt)
      # Return elements.
      return teaserElmnts

###################################################################################################
