###################################################################################################
# zmstable.py
#
# $Id: zmstable.py,v 1.6 2004/11/23 23:04:51 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.6 $
#
# Implementation of class ZMSTable (see below).
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
from Globals import HTMLFile
import urllib
import copy
# Product Imports.
from zmsobject import ZMSObject
import _globals
import _metadata


###################################################################################################
###################################################################################################
###   
###   constructor ZMSTable:
###   
###################################################################################################
###################################################################################################
manage_addZMSTableForm = HTMLFile('manage_addzmstableform', globals()) 
def manage_addZMSTable(self, lang, manage_lang, _sort_id, REQUEST, RESPONSE):
  """ manage_addZMSTable """
  
  if REQUEST['btn'] == self.getLangStr('BTN_INSERT',manage_lang):
    
    ##### Create ####
    id_prefix = _globals.id_prefix(REQUEST.get('id','e'))
    obj = ZMSTable(self.getNewId(id_prefix),_sort_id+1)
    self._setObject(obj.id, obj)
    
    obj = getattr(self,obj.id)
    ##### VersionManager ####
    obj.setObjStateNew(REQUEST)
    ##### Init Coverage ####
    coverage = self.getDCCoverage(REQUEST)
    if coverage.find('local.')==0:
      obj.setObjProperty('attr_dc_coverage',coverage)
    else:
      obj.setObjProperty('attr_dc_coverage','global.'+lang)
    ##### Init Properties ####
    obj.setObjProperty('active',1,lang)
    obj.__init_table__(REQUEST['table_type'],REQUEST['table_rows'],REQUEST['table_cols'],REQUEST)
    ##### VersionManager ####
    obj.onChangeObj(REQUEST)
    
    ##### Normalize Sort-IDs ####
    self.normalizeSortIds(id_prefix)
    
    message = self.getLangStr('MSG_INSERTED',manage_lang)%obj.display_type(REQUEST)
    RESPONSE.redirect('%s/%s/manage_main?lang=%s&manage_lang=%s&manage_tabs_message=%s'%(self.absolute_url(),obj.id,lang,manage_lang,urllib.quote(message)))
  
  else:
    RESPONSE.redirect('%s/manage_main?lang=%s&manage_lang=%s'%(self.absolute_url(),lang,manage_lang))


###################################################################################################
###################################################################################################
###   
###   class ZMSTable:
###   
###################################################################################################
###################################################################################################
class ZMSTable(ZMSObject, _metadata.Metadata):

    # Properties.
    # -----------
    meta_type = "ZMSTable"
    icon = "misc_/zms/zmstable.gif"
    icon_disabled = "misc_/zms/zmstable_disabled.gif"

    # Management Options.
    # -------------------
    manage_options = ( 
	{'label': 'TAB_EDIT',       'action': 'manage_main'},
	{'label': 'TAB_REFERENCES', 'action': 'manage_RefForm'},
	{'label': 'TAB_HISTORY',    'action': 'manage_UndoVersionForm'},
	{'label': 'TAB_PREVIEW',    'action': 'preview_html'}, # empty string defaults to index_html
	) 

    # Management Permissions.
    # -----------------------
    __authorPermissions__ = (
                'manage','manage_main','manage_workspace',
                'manage_changeProperties',
                'manage_moveObjUp','manage_moveObjDown',
                'manage_cutObjects','manage_copyObjects','manage_pasteObjs',
		'manage_userForm','manage_user',
                )
    __ac_permissions__=(
                ('ZMS Author', __authorPermissions__),
                )

    # Properties.
    # -----------
    __obj_attrs__ = {
        # Changed by
        'change_uid':{'datatype':'string', 'multilang':True, 'xml':False, 'lang_inherit':False},
        'change_dt':{'datatype':'datetime', 'multilang':True, 'xml':False, 'lang_inherit':False},
        # Properties
        'sort_id':{'datatype':'string' ,'xml':False},
        'active':{'datatype':'boolean' ,'multilang':True},
        'attr_active_start':{'datatype':'datetime' ,'multilang':True},
        'attr_active_end':{'datatype':'datetime' ,'multilang':True},
        'type':{'datatype':'int' ,'default':True},
        'rows':{'datatype':'int' ,'multilang':True},
        'cols':{'datatype':'int' ,'multilang':True},
        'table':{'datatype':'list' ,'multilang':True},
        'caption':{'datatype':'string' ,'multilang':True},
        'align':{'datatype':'string', 'type':'select','default':'TOP','options':['TOP','TOP','BOTTOM','BOTTOM','LEFT','LEFT','RIGHT','RIGHT'], 'mandatory':1},
        # Meta-Data
        'attr_dc_coverage':{'datatype':'string'},
        # Meta-Dictionaries        
        '$metadict':{'datatype':'MetaDict'},
    }


    # Management Interface
    # ---------------------
    manage_main = HTMLFile('dtml/zmstable/manage_main', globals()) 
    table_cell_edit_html = HTMLFile('dtml/zmstable/table_cell_edit', globals())


    """
    ###############################################################################################    
    #
    #   CONSTRUCTOR
    #
    ###############################################################################################    
    """

    # -------------------------------------------------------------------------------------------------
    #  ZMSTable.recurse_updateVersion:
    #
    #  Update version.
    # -------------------------------------------------------------------------------------------------
    def recurse_updateVersion(self, REQUEST):
      message = ''
        
      # Process super-objects.
      message += ZMSObject.recurse_updateVersion(self,REQUEST)
        
      # Process object.
      # [...]
        
      # Return with message.            
      return message


    # ------------------------------------------------------------------------------------------
    # ZMSTable.__init_table__: 
    #
    # Initialise table.
    # ------------------------------------------------------------------------------------------
    def __init_table__(self, iType, iRows, iCols, REQUEST): 
    
      ##### Properties #####
            
      self.setObjProperty('type',iType)
        
      for s_lang in self.getLangIds():
        
        oTable = []

        #  <TH> <TH> <TH>
	#  <td> <td> <td>
	#  <td> <td> <td>
	if iType == 1:
	  oRow = []
	  for iCol in range(iCols):
	    oRow.append(self.__init_cell__('th',1))
	  oTable.append(oRow)
	  for iRow in range(1,iRows):
	    oRow = []
	    for iCol in range(iCols):
	      oRow.append(self.__init_cell__('td',1))
	    oTable.append(oRow)

	#  <     TH     >
	#  <td> <td> <td>
	#  <td> <td> <td>
	elif iType == 2:
	    oRow = [self.__init_cell__('th',iCols)]
	    oTable.append(oRow)
	    for iRow in range(1,iRows):
		oRow = []
		for iCol in range(iCols):
		    oRow.append(self.__init_cell__('td',1))
		oTable.append(oRow)

	#  <TH> <td> <td>
	#  <TH> <td> <td>
	#  <TH> <td> <td>
	elif iType == 3:
	    for iRow in range(iRows):
		oRow = [self.__init_cell__('th',1)]
		for iCol in range(1,iCols):
		    oRow.append(self.__init_cell__('td',1))
		oTable.append(oRow)

	#       <TH> <TH>
	#  <TH> <td> <td>
	#  <TH> <td> <td>
	elif iType == 4:
	  oRow = []
	  oRow.append(self.__init_cell__('td',1))
	  for iCol in range(1,iCols):
	    oRow.append(self.__init_cell__('th',1))
	  oTable.append(oRow)
	  for iRow in range(1,iRows):
	    oRow = [self.__init_cell__('th',1)]
	    for iCol in range(1,iCols):
	      oRow.append(self.__init_cell__('td',1))
            oTable.append(oRow)

	#  <td> <td> <td>
	#  <td> <td> <td>
	#  <td> <td> <td>
	elif iType == 5:
	  for iRow in range(iRows):
	    oRow = []
  	    for iCol in range(iCols):
	      oRow.append(self.__init_cell__('td',1))
            oTable.append(oRow)

	self.setObjProperty('table',oTable,s_lang)
	self.setObjProperty('rows',iRows,s_lang)
	self.setObjProperty('cols',iCols,s_lang)


    # ---------------------------------------------------------------------------------------------
    #	ZMSTable.getSpanOptions:
    # ---------------------------------------------------------------------------------------------
    def getSpanOptions(self, i, n):
      options = []
      for o in range(1, n-i+1):
        options.append((o,o))
      return options


    """
    ###############################################################################################    
    ###
    ###   P r o p e r t i e s
    ###
    ###############################################################################################    
    """

    ###############################################################################################
    #  ZMSTable.manage_changeProperties: 
    #
    #  Change Table properties.
    ###############################################################################################
    def manage_changeProperties(self, lang, manage_lang, REQUEST, RESPONSE): 
        """ ZMSTable.manage_changeProperties """
        
        message = ''
        if (len(REQUEST.get('function','')) > 0) or \
           (REQUEST.get('btn','') != self.getLangStr('BTN_CANCEL',manage_lang)):
        
          ##### Object State #####
          self.setObjStateModified(REQUEST)
            
          ##### Properties #####
          # Active.
          self.setReqProperty('active',REQUEST)
          self.setReqProperty('attr_active_start',REQUEST)
          self.setReqProperty('attr_active_end',REQUEST)
          # Type.
          if REQUEST.has_key('type'): 
            self.setReqProperty('type',REQUEST)
          # Caption.
          self.setReqProperty('caption',REQUEST)
          self.setReqProperty('align',REQUEST)

          ##### Metadata ####
          self.setMetadata(lang,manage_lang,REQUEST)
        
          for sKey in REQUEST.keys():
            if sKey.find('cell') == 0 and \
               len(sKey.split('_')) == 3:
              i_col = int(sKey.split('_')[1])
              i_row = int(sKey.split('_')[2])
              tag = REQUEST['tag_%i_%i'%(i_col,i_row)]
              content = REQUEST['cell_%i_%i'%(i_col,i_row)]
              format = REQUEST['format_%i_%i'%(i_col,i_row)]
              self.setCell(i_col,i_row,tag,content,format,REQUEST)
          
          if REQUEST.has_key('function'):
            sFunction = REQUEST['function']
            sRow = REQUEST['row']
            sCol = REQUEST['col']
            if len(sFunction) > 0 and len(sRow) > 0 and len(sCol) > 0:
              iRow = int(sRow)
              iCol = int(sCol)
              if sFunction == 'move_row_down':
                self.move_row(iRow,1,lang,REQUEST)
              elif sFunction == 'move_row_up':
                self.move_row(iRow,-1,lang,REQUEST)
              elif sFunction == 'delete_row':
                self.delete_row(iRow,lang,REQUEST)
              elif sFunction == 'insert_row':
                self.insert_row(iRow,lang,REQUEST)
              elif sFunction == 'move_col_right':
                self.move_col(iCol,1,lang,REQUEST)
              elif sFunction == 'move_col_left':
                self.move_col(iCol,-1,lang,REQUEST)
              elif sFunction == 'delete_col':
                self.delete_col(iCol,lang,REQUEST)
              elif sFunction == 'insert_col':
                self.insert_col(iCol,lang,REQUEST)
          
          ##### VersionManager ####
          self.onChangeObj(REQUEST)
          
          ##### Message #####
          message = self.getLangStr('MSG_CHANGED',manage_lang)
          
          if (REQUEST.has_key('function') and len(REQUEST['function'])>0):
            return RESPONSE.redirect('manage_main?lang=%s&manage_lang=%s&manage_tabs_message=%s'%(lang,manage_lang,urllib.quote(message)))
        
        # Return with message.
        self.checkIn(REQUEST)
        return RESPONSE.redirect('%s/manage_main?lang=%s&manage_lang=%s&manage_tabs_message=%s#_%s'%(self.getParentNode().absolute_url(),lang,manage_lang,urllib.quote(message),self.id))


    # -------------------------------------------------------------------------------------------------
    #  ZMSTable.isPageElement:
    # -------------------------------------------------------------------------------------------------
    def isPageElement(self): 
      return True

    # ---------------------------------------------------------------------------------------------
    #  ZMSTable.getTitlealt
    # ---------------------------------------------------------------------------------------------
    def getTitlealt(self,REQUEST): 
      return self.display_type(REQUEST)

    # ---------------------------------------------------------------------------------------------
    #  ZMSTable.getTable
    # ---------------------------------------------------------------------------------------------
    def getTable(self, REQUEST): 
      return self.getObjProperty('table',REQUEST)

    # ---------------------------------------------------------------------------------------------
    #  ZMSTable.getRow
    # ---------------------------------------------------------------------------------------------
    def getRow(self, row, REQUEST): 
      return self.getTable(REQUEST)[row]

    # ------------------------------------------------------------------------------------------
    #  ZMSTable.getCell
    # ------------------------------------------------------------------------------------------
    def getCell(self, row, col, REQUEST): 
      return self.getRow(row,REQUEST)[col]


    ###############################################################################################    
    # Column
    ###############################################################################################    

    # ---------------------------------------------------------------------------------------------
    #	ZMSTable.insert_col:
    # ---------------------------------------------------------------------------------------------
    def insert_col(self, iCol, lang, REQUEST):
      #
      iRow = 0
      for oRow in self.getTable(REQUEST):
        if not (iRow == 0 and self.getObjProperty('type',REQUEST) == 2):
          cell = self.__init_cell__('td',1)
          if iRow > 0 or self.getObjProperty('type',REQUEST) in [3,5]:
            cell['tag'] = 'td'
          else:
            cell['tag'] = 'th'
          oRow.insert(iCol,cell)
        iRow = iRow + 1
      # increase number of columns
      self.setObjProperty('cols',self.getObjProperty('cols',REQUEST)+1,lang)
      #
      if self.getObjProperty('type',REQUEST) == 2:
        cell = self.getCell(0,0,REQUEST)
        cell['colspan'] = self.getObjProperty('cols',REQUEST)

    # ---------------------------------------------------------------------------------------------
    #	ZMSTable.delete_col:
    # ---------------------------------------------------------------------------------------------
    def delete_col(self, iCol, lang, REQUEST):
      #
      iRow = 0
      for oRow in self.getTable(REQUEST):
       if not (iRow == 0 and self.getObjProperty('type',REQUEST) == 2):
         oRow.remove(self.getCell(iRow,iCol,REQUEST))
       iRow = iRow + 1
      # decrease number of columns
      self.setObjProperty('cols',self.getObjProperty('cols',REQUEST)-1,lang)
      #
      if self.getObjProperty('type',REQUEST) == 2:
        cell = self.getCell(0,0,REQUEST)
        cell['colspan'] = self.getObjProperty('cols',REQUEST)

    # ---------------------------------------------------------------------------------------------
    #	ZMSTable.move_col:
    #
    #	Move column left or right.
    # ---------------------------------------------------------------------------------------------
    def move_col(self, iCol, iDirection, lang, REQUEST):
        iRow = 0
        for oRow in self.getTable(REQUEST):
            if not (iRow == 0 and self.getObjProperty('type',REQUEST) == 2):
                cell1 = self.getCell(iRow,iCol,REQUEST)
                cell2 = self.getCell(iRow,iCol+iDirection,REQUEST)
                sContent = cell1['content']
                cell1['content'] = cell2['content']
                cell2['content'] = sContent
            iRow = iRow + 1


    ###############################################################################################    
    # Row
    ###############################################################################################    

    # ---------------------------------------------------------------------------------------------
    #	ZMSTable.insert_row:
    # ---------------------------------------------------------------------------------------------
    def insert_row(self, iRow, lang, REQUEST):
        # increase number of rows
        self.setObjProperty('rows',self.getObjProperty('rows',REQUEST)+1,lang)
        #
        oRow = []
        #
        if self.getObjProperty('type',REQUEST) in [1,2]:
          for iCol in range(self.getObjProperty('cols',REQUEST)):
            oRow.append(self.__init_cell__('td',1))
        #
        elif self.getObjProperty('type',REQUEST) in [3,4]:
          oRow.append(self.__init_cell__('th',1))
          for iCol in range(1,self.getObjProperty('cols',REQUEST)):
            oRow.append(self.__init_cell__('td',1))
        #
        elif self.getObjProperty('type',REQUEST) in [5]:
          for iCol in range(self.getObjProperty('cols',REQUEST)):
            oRow.append(self.__init_cell__('td',1))
        #
        self.getTable(REQUEST).insert(iRow,oRow)

    # ---------------------------------------------------------------------------------------------
    #	ZMSTable.delete_row:
    # ---------------------------------------------------------------------------------------------
    def delete_row(self, iRow, lang, REQUEST):
        # decrease number of rows
        self.setObjProperty('rows',self.getObjProperty('rows',REQUEST)-1,lang)
        #
        self.getTable(REQUEST).remove(self.getRow(iRow,REQUEST))

    # ---------------------------------------------------------------------------------------------
    #	ZMSTable.move_row:
    #
    #	Move row up or down.
    # ---------------------------------------------------------------------------------------------
    def move_row(self, iRow, iDirection, lang, REQUEST):
        oRow1 = copy.deepcopy(self.getRow(iRow+iDirection,REQUEST))
        oRow2 = copy.deepcopy(self.getRow(iRow,REQUEST))
        self.getTable(REQUEST)[iRow+iDirection] = oRow2
        self.getTable(REQUEST)[iRow] = oRow1


    """
    ###############################################################################################
    ###
    ###  H T M L - P r e s e n t a t i o n 
    ###
    ###############################################################################################
    """

    # ------------------------------------------------------------------------------------------
    #  ZMSTable.getBodyContent:
    #         
    #  HTML presentation of Table. 
    # ------------------------------------------------------------------------------------------
    def _getBodyContent(self, REQUEST):
      type = self.getObjProperty('type',REQUEST)
      table = self.getObjProperty('table',REQUEST)
      s = []
      s.append('\n<table')
      # Summary
      tableSummary = self.getObjProperty('attr_dc_description',REQUEST)
      if tableSummary:
        s.append(' summary="'+tableSummary+'"')
      s.append('>')
      # Caption
      s.append('\n<caption align="' + self.getObjProperty('align',REQUEST) + '">' + self.getObjProperty('caption',REQUEST) + '</caption>')
      i_row = 0
      tag = None
      for row in table:
        newtag = None
        if (type in [1,2,4] and i_row == 0):
          newtag = 'thead'
        elif (type in [1,2,4] and i_row == 1) or (i_row == 0):
          newtag = 'tbody'
        if newtag is not None:
          if tag is not None:
            s.append('\n</' + tag + '>')
          s.append('\n<' + newtag + '>')
          tag = newtag
        s.append('\n<tr')
        if i_row%2==0:
          s.append(' class="even"')
        else:
          s.append(' class="odd"')
        s.append('>')
        i_col = 0
        for cell in row:
          if i_row == 0 and i_col == 0 and type == 4:
            s.append('\n<td></td>')
          else:
            # Retrieve properties.
            text = cell['content']
            textformat = cell['format']
            # Render HTML presentation.
            text = self.renderText( textformat, text, REQUEST)
            try:
              text = _globals.dt_html(self,text,REQUEST)
            except:
              text = _globals.writeException(self,'[_getBodyContent]: (%i,%i)'%(i_col, i_row))
            text = self.renderContentEditable('table_%i_%i'%(i_col, i_row), text, REQUEST)
            s.append('\n<%s'%cell['tag'])
	    if int(cell['colspan']) > 1:
              s.append(' colspan="%i"'%int(cell['colspan']))
            s.append('>')
            s.append(text)
            s.append('</%s>'%cell['tag'])
          i_col = i_col + 1
        s.append('\n</tr>')
        i_row = i_row + 1
      if tag is not None:
        s.append('\n</' + tag + '>')
      s.append('\n</table>')
      # Return body-content.
      bodyContent = ''.join(s)
      return '<div class="%s" id="%s">%s</div>'%(self.meta_type, self.id, bodyContent )


    # ------------------------------------------------------------------------------------------
    #  ZMSTable.renderShort:
    #
    #  Renders short presentation of Table.
    # ------------------------------------------------------------------------------------------
    def renderShort(self,REQUEST):
      return self._getBodyContent(REQUEST)


    # ------------------------------------------------------------------------------------------
    #  ZMSTable.catalogText:
    #
    #  Catalog text of Table (overwrite method from ZCatalogItem).
    # ------------------------------------------------------------------------------------------
    def catalogText(self, REQUEST):
      s = ''
      if self.isVisible(REQUEST):
        table = self.getObjProperty('table',REQUEST)
        for row in table:
          for cell in row:
            s += cell['content'] + ' '
      return s


    """
    ###############################################################################################    
    #
    #   C e l l 
    #
    ###############################################################################################    
    """

    # ------------------------------------------------------------------------------------------
    #  ZMSTable.__init_cell__:
    #
    #  Initialise table-cell.
    # ------------------------------------------------------------------------------------------
    def __init_cell__(self, tag='', colspan=1, content=''):
        cell = {}
        cell['tag'] = tag
        cell['colspan'] = colspan
        cell['content'] = content
        cell['format'] = self.getTextFormatDefault()
        return cell

    # ------------------------------------------------------------------------------------------
    #  ZMSTable.setCell:
    #
    #  Set content of table-cell.
    # ------------------------------------------------------------------------------------------
    def setCell(self, col, row, tag, content, format, REQUEST):
      req = {'lang':REQUEST['lang'],'preview':'preview'}
      cell = self.getCell(row,col,req)
      cell['tag'] = tag
      cell['content'] = content
      cell['format'] = format

###################################################################################################
