from support import *

class RenderingTests(unittest.TestCase):
    def setUp(self):
        self.p = MockZWikiPage().aq_parent.TestPage

    def test_render_stxprelinkdtmlfitissuehtml(self):
        self.p.edit(text='! PageOne PageTwo\n',type='stxprelinkdtmlfitissuehtml')
        self.assertEquals(self.p._render(bare=1),'<p> PageOne PageTwo</p>\n')

    def test_render_stxprelinkdtmlhtml(self):
        self.p.edit(text='! PageOne PageTwo\n',type='stxprelinkdtmlhtml')
        self.assertEquals(self.p._render(bare=1),'<p> PageOne PageTwo</p>\n')

    def test_render_stxdtmllinkhtml(self):
        self.p.edit(text='! PageOne PageTwo\n',type='stxdtmllinkhtml')
        self.assertEquals(self.p._render(bare=1),'<p> PageOne PageTwo</p>\n')

    def test_render_dtmlstxlinkhtml(self):
        self.p.edit(text='! PageOne PageTwo\n',type='dtmlstxlinkhtml')
        self.assertEquals(self.p._render(bare=1),'<p> PageOne PageTwo</p>\n')

    def test_render_stxprelinkhtml(self):
        self.p.edit(text='! PageOne PageTwo\n',type='stxprelinkhtml')
        self.assertEquals(self.p._render(bare=1),'<p> PageOne PageTwo</p>\n')

    def test_render_stxlinkhtml(self):
        self.p.edit(text='! PageOne PageTwo\n',type='stxlinkhtml')
        self.assertEquals(self.p._render(bare=1),'<p> PageOne PageTwo</p>\n')

    def test_render_stxprelink(self):
        self.p.edit(text='! PageOne PageTwo\n',type='stxprelink')
        self.assertEquals(self.p._render(bare=1),'<p> PageOne PageTwo</p>\n')
        self.p.edit(text='"link containing WikiName":url\n',type='stxprelink')
        self.assertEquals(self.p._render(bare=1),
                          '<p><a href="url">link containing WikiName</a></p>\n')

    def test_render_stxlink(self):
        self.p.edit(text='! PageOne PageTwo\n',type='stxlink')
        self.assertEquals(self.p._render(bare=1),'<p> PageOne PageTwo</p>\n')
        self.p.edit(text='"link text":url\n',type='stxlink')
        self.assertEquals(self.p._render(bare=1),
                          '<p><a href="url">link text</a></p>\n')

    def test_render_prelinkdtmlhtml(self):
        self.p.edit(text='! PageOne PageTwo\n',type='prelinkdtmlhtml')
        self.assertEquals(self.p._render(bare=1),' PageOne PageTwo\n')

    def test_render_dtmllinkhtml(self):
        self.p.edit(text='! PageOne PageTwo\n',type='dtmllinkhtml')
        self.assertEquals(self.p._render(bare=1),' PageOne PageTwo\n')

    def test_render_prelinkhtml(self):
        self.p.edit(text='! PageOne PageTwo\n',type='prelinkhtml')
        self.assertEquals(self.p._render(bare=1),' PageOne PageTwo\n')

    def test_render_linkhtml(self):
        self.p.edit(text='! PageOne PageTwo\n',type='linkhtml')
        self.assertEquals(self.p._render(bare=1),' PageOne PageTwo\n')

    def test_render_dtmlhtml(self):
        self.p.edit(text='! PageOne PageTwo\n',type='dtmlhtml')
        self.assertEquals(self.p._render(bare=1),'! PageOne PageTwo\n')

    def test_render_html(self):
        self.p.edit(text='! PageOne PageTwo\n',type='html')
        self.assertEquals(self.p._render(bare=1),'! PageOne PageTwo\n')

    def test_render_wwmlprelink(self):
        self.p.edit(text='! PageOne PageTwo\n',type='wwmlprelink')
        self.assertEquals(self.p._render(bare=1),'    PageOne PageTwo\n<P>')

    def test_render_wwmllink(self):
        self.p.edit(text='! PageOne PageTwo\n',type='wwmllink')
        self.assertEquals(self.p._render(bare=1),'    PageOne PageTwo\n<P>')

    def test_render_textlink(self):
        self.p.edit(text='! PageOne PageTwo\n',type='plaintext')
        self.assertEquals(self.p._render(bare=1),
                          '<pre>\n! PageOne PageTwo\n\n</pre>\n')

    def test_render_plaintext(self):
        self.p.edit(text='! PageOne PageTwo\n',type='plaintext')
        self.assertEquals(self.p._render(bare=1),
                          '<pre>\n! PageOne PageTwo\n\n</pre>\n')

    def test__renderLink(self):
        self.assertEquals(
            self.p._renderLink('[unbalanced (]')[-53:],
            'page=unbalanced%20%28" title="create this page">?</a>')

    def test_renderLinksIn(self):
        self.assertEquals(self.p.renderLinksIn('nolink'),'nolink')
        self.assertEquals(self.p.renderLinksIn('http://a.b.c/d'),
                          '<a href="http://a.b.c/d">http://a.b.c/d</a>')
        self.assertEquals(self.p.renderLinksIn('mailto://a@b.c'),
                          '<a href="mailto://a@b.c">mailto://a@b.c</a>')
        self.assertEquals(self.p.renderLinksIn('TestPage'),
                          '<a href="http://foo/foo/test//TestPage" title="last edited some time ago">TestPage</a>')
        self.assertEquals(self.p.renderLinksIn('NewTestPage'),
                          'NewTestPage<a class="new" href="http://foo/foo/test//TestPage/editform?page=NewTestPage" title="create this page">?</a>')
        self.assertEquals(self.p.renderLinksIn('!TestPage'),'TestPage')
        self.assertEquals(self.p.renderLinksIn('[newpage]'),
                          '[newpage]<a class="new" href="http://foo/foo/test//TestPage/editform?page=newpage" title="create this page">?</a>')
        # a problem with escaping remote wiki links was reported
        self.p.edit(text='RemoteWikiURL: URL/')
        self.assertEquals(self.p.renderLinksIn('TestPage:REMOTEPAGE'),
                          '<a href="URL/REMOTEPAGE">TestPage:REMOTEPAGE</a>')
        self.assertEquals(self.p.renderLinksIn('!TestPage:REMOTEPAGE'),
                          'TestPage:REMOTEPAGE')
        self.assertEquals(self.p.renderLinksIn('[ ]'),
                          '[ ]<a class="new" href="http://foo/foo/test//TestPage/editform?page=%20" title="create this page">?</a>')
        # do display the brackets prior to page creation
        self.assertEquals(self.p.renderLinksIn('[newpage]'),
                          '[newpage]<a class="new" href="http://foo/foo/test//TestPage/editform?page=newpage" title="create this page">?</a>')
        # don't link wikinames inside <a href...>...</a>
        self.assertEquals(self.p.renderLinksIn('<a href>WikiName</a>'),
                          '<a href>WikiName</a>')
        # do link wikinames after <a name...> with no closing </a>
        self.assertEquals(self.p.renderLinksIn('<a name>WikiName'),
                          '<a name>WikiName<a class="new" href="http://foo/foo/test//TestPage/editform?page=WikiName" title="create this page">?</a>')

    # old
    def test_render_structuredtextdtml(self):
        self.p.edit(type='structuredtextdtml')

        self.p.edit(text='<a href="TestPage">link</a>')
        if ZOPEVERSION < (2,4):
            # with zope2.3/python1.5 there's an extra newline
            self.assertEquals(self.p(bare=1),
                              '<p><a href="TestPage">link</a></p>\n\n')
        else:
            self.assertEquals(self.p(bare=1),
                              '<p><a href="TestPage">link</a></p>\n')

        self.p.edit(text="'<>'")
        if ZOPEVERSION < (2,4):
            # with zope2.3/python1.5 they don't get quoted (eh?)
            self.assertEquals(self.p(bare=1),'<p><code><></code></p>\n\n')
        else:
            self.assertEquals(self.p(bare=1),'<p><code>&lt;&gt;</code></p>\n')


def test_suite():
    suite = unittest.TestSuite()
    suite.addTest(unittest.makeSuite(RenderingTests))
    return suite

def main():
    unittest.TextTestRunner().run(test_suite())

if __name__ == '__main__':
    main()
