/***************************************************************************
 *
 * COPYRIGHTHERE
 *
 * $Id: connection.c,v 1.4.2.4 2003/03/06 19:29:29 sasa Exp $
 *
 * Author  : SaSa
 * Auditor :
 * Last audited version:
 * Notes:
 *
 ***************************************************************************/

#include <zorp/connection.h>

/* support functions for ZConnection */

ZConnection *
z_connection_new(void)
{
  return g_new0(ZConnection, 1);
}

gchar *
z_connection_format(ZConnection *conn, gchar *buf, gint buflen)
{
  gchar buf_remote[MAX_SOCKADDR_STRING], buf_local[MAX_SOCKADDR_STRING], buf_dest[MAX_SOCKADDR_STRING];
  
  if (!conn)
    {
      g_strlcpy(buf, "conn='NULL'", buflen);
      return buf;
    }
  
  if (conn->remote)
    z_sockaddr_format(conn->remote, buf_remote, sizeof(buf_remote));
  else
    strcpy(buf_remote, "NULL");
  if (conn->local)
    z_sockaddr_format(conn->local, buf_local, sizeof(buf_local));
  else
    strcpy(buf_local, "NULL");
  if (conn->dest)
    z_sockaddr_format(conn->dest, buf_dest, sizeof(buf_dest));
  else
    strcpy(buf_dest, "NULL");
  g_snprintf(buf, buflen, "protocol='%d', remote='%s', local='%s', dest='%s'", conn->protocol, buf_remote, buf_local, buf_dest);
  return buf;
}

void
z_connection_destroy(ZConnection *conn, gboolean close)
{
  if (close)
    z_stream_close(conn->stream, NULL);
  z_sockaddr_unref(conn->remote);
  z_sockaddr_unref(conn->local);
  z_sockaddr_unref(conn->dest);
  z_sockaddr_unref(conn->bound);
  z_stream_unref(conn->stream);
  g_free(conn);
}
