/***************************************************************************
 *
 * COPYRIGHTHERE
 *
 * $Id: modules.c,v 1.11.2.2 2002/10/30 06:20:40 sasa Exp $
 *
 * Author  : Bazsi
 * Auditor :
 * Last audited version:
 * Notes:
 *
 ***************************************************************************/

#include <zorp/zorp.h>
#include <zorp/log.h>
#include <gmodule.h>

/*+

  Loads the given proxy module from disk, and calls its initialize
  function.

  Parameters:
    modname        module name to load without path or extension 
                   information

  Returns:
    TRUE on success

  +*/
gint
z_load_module(gchar *modname)
{
  GModule *m;
  gchar *buf;
  gint (*modinit)(void);
  
  z_enter();
  buf = g_module_build_path(ZORP_LIBDIR, modname);
  m = g_module_open(buf, 0);
  if (m &&
      g_module_symbol(m, "zorp_module_init", (gpointer *) &modinit) &&
      modinit())
    {
      /*LOG
        This message serves informational purposes, and indicates that
        the given module was successfully loaded from the given shared
        object.
       */
      z_log(NULL, CORE_DEBUG, 8, "Module successfully loaded; module='%s', file='%s'", modname, buf);
      g_free(buf);
      z_leave();
      return TRUE;
    }
  else
    {
      /*LOG
        This message indicates that loading a proxy module failed.
       */
      z_log(NULL, CORE_ERROR, 1, "Module loading failed; module='%s', file='%s', error='%s'", modname, buf, g_module_error());
    }
  g_free(buf);
  z_leave();
  return FALSE;
}
