#ifndef ZORP_ATTACH_H_INCLUDED
#define ZORP_ATTACH_H_INCLUDED

#include <zorp/zorp.h>
#include <zorp/connection.h>

typedef struct _ZAttachTCPParams
{
  gint timeout;
} ZAttachTCPParams;

typedef struct _ZAttachUDPParams
{
  gchar *tracker;
} ZAttachUDPParams;

typedef union _ZAttachParams
{
  ZAttachTCPParams tcp;
  ZAttachUDPParams udp;
} ZAttachParams;

typedef struct _ZAttach ZAttach;

typedef void (*ZAttachCallback)(ZConnection *, gpointer user_data);

ZAttach *z_attach_new(gchar *session_id, 
                      guint proto, ZSockAddr *local, ZSockAddr *remote, 
                      ZAttachParams *params, 
                      ZAttachCallback callback, gpointer user_data, GDestroyNotify notify);
gboolean z_attach_start(ZAttach *self);
void z_attach_cancel(ZAttach *self);
ZConnection *z_attach_block(ZAttach *self);
ZSockAddr *z_attach_get_local(ZAttach *self);
ZAttach *z_attach_ref(ZAttach *self);
void z_attach_unref(ZAttach *self);

#endif
