#ifndef ZORP_CT_H_INCLUDED
#define ZORP_CT_H_INCLUDED

#include <zorp/proxy.h>
#include <zorp/zorp.h>

#if ENABLE_CONNTRACK

#include <zorp/poll.h>
#include <zorp/sockaddr.h>
#include <zorp/stream.h>
#include <zorp/packet.h>

#define ZCT_DST_IP	0x0001
#define ZCT_SRC_IP	0x0100
#define ZCT_DST_PORT	0x0002
#define ZCT_SRC_PORT	0x0200

#define MAX_TRACKER_NAME 64

struct _ZCTSocket;
struct _ZConntrack;
struct _ZorpCTracker;
struct _ZCTTracker;

#define ZTR_OK 1
#define ZTR_END 2
#define ZTR_DROP 3

#define ZCS_TO_CLIENT 1
#define ZCS_TO_SERVER 2
#define ZCS_MASTER 3

typedef struct _ZCTSocket
{
  gchar session_id[MAX_SESSION_ID];
  gint type;
  GStaticMutex ref_lock;
  gint ref_cnt;
  struct _ZCTProtoHelper *helper;
  
  /* The ct side of the proxy stream-pair. This is where we can pull proxy
   * messages, or send further packets. */
  
  ZStream *ct_stream;

  /* */
  ZSockAddr *local_addr;
  ZSockAddr *remote_addr;
  
  /* user_data passed to protocol specific tracker functions */
  struct _ZCTProtoHelper *helper_data;
  
  /* underlying socket we've created, which is explicitly bound */
  ZStream *fd_stream;
} ZCTSocket;


typedef struct _ZCTProtoHelper
{
  ZCTSocket *sock;
  gint type;

  void (*free_fn)(struct _ZCTProtoHelper *self);
  gint (*to_client_fn)(struct _ZCTProtoHelper *self, ZPacket *p);
  gint (*to_server_fn)(struct _ZCTProtoHelper *self, ZPacket *p);

} ZCTProtoHelper;

void
z_ct_proto_helper_init(ZCTProtoHelper *self, ZCTSocket *sock, gint type);

/* registry entries for helpers contain this type */
typedef ZCTProtoHelper *(*ZCTCreateProtoHelperFunc)(struct _ZCTSocket *sock, gint type);

typedef gboolean (*ZCTAcceptFunc)(ZStream *stream, ZSockAddr *remote,
			          ZSockAddr *dest, gpointer user_data);


/*
 * ZConntrack encapsulates a datagram mode listener. It takes care of
 * receiving packets on the receiver fd, organizes packets into sessions
 * (based on the peer's address and the protocol information found).
 *
 * On new sessions a callback is called, on packets which belong to already
 * known session, the packet is send to the correct proxy instance.
 */
typedef struct _ZConntrack
{
  guint ref_cnt;
  gchar session_id[MAX_SESSION_ID];
  gint session_limit;

  gchar tracker_name[MAX_TRACKER_NAME];
  
  /* address we were bound to */
  ZSockAddr *bind_addr;
  ZSockAddr *bound_addr;
  
  /* stream bound to sock above */
  ZStream *fd_stream;
  
  /* callback to be called when a new session is found */
  ZCTAcceptFunc callback;
  
  /* callback to be passed to callback */
  gpointer callback_data;
  
  GDestroyNotify callback_data_notify;
} ZConntrack;

ZConntrack *
z_conntrack_new(gchar *session_id, 
		ZSockAddr *bind_addr, 
		gint session_limit,
		gchar *tracker_name,
		ZCTAcceptFunc callback, 
		gpointer user_data);
		
gboolean z_conntrack_start(ZConntrack *self);
void z_conntrack_cancel(ZConntrack *self);
void z_conntrack_ref(ZConntrack *self);
void z_conntrack_unref(ZConntrack *self);

ZCTSocket *z_conntrack_socket_new(gchar *session_id, gchar *tracker_name, ZSockAddr *src, ZSockAddr *dest, gint type, ZStream **proxy_stream);
void z_conntrack_socket_ref(ZCTSocket *self);
void z_conntrack_socket_unref(ZCTSocket *self);

void z_conntrack_socket_start(ZCTSocket *self);

gboolean z_conntrack_init(void);
void z_conntrack_destroy(void);

#else

#define z_conntrack_init() TRUE
#define z_conntrack_destroy()

#endif

#endif
