/***************************************************************************
 *
 * COPYRIGHTHERE
 *
 * $Id: proxyvars.h,v 1.2.2.3 2002/11/13 09:05:38 bazsi Exp $
 *
 ***************************************************************************/

#ifndef ZORP_PYVARS_H_INCLUDED
#define ZORP_PYVARS_H_INCLUDED

#include <zorp/zorp.h>
#include <zorp/policy.h>

struct _ZProxy;

typedef struct _ZProxyVars 
{
  GHashTable *vars;
  struct _ZSessionVars *session_vars;
} ZProxyVars;

typedef struct _ZSessionVars
{
  GHashTable *vars;
} ZSessionVars;

/* callbacks usable as Python callbacks for setattr/getattr */
gint z_proxy_vars_setattr(struct _ZProxy *self, gchar *name, ZPolicyObj *new);

ZPolicyObj *z_proxy_vars_getattr(struct _ZProxy *self, gchar *name);

ZProxyVars *z_proxy_vars_new(void);
void z_proxy_vars_destroy(ZProxyVars *vars);
void z_proxy_vars_dump_values(ZProxyVars *vars, struct _ZProxy *proxy);
void z_proxy_vars_set_session(ZProxyVars *vars, ZSessionVars *session);
void z_proxy_vars_var_new(GHashTable *hash, gchar *name, guint flags, ...);
void z_proxy_vars_set_active_session(struct _ZProxy *self, struct _ZSessionVars *vars);

ZSessionVars *z_session_vars_new(void);
void z_session_vars_destroy(ZSessionVars *self);

#endif
