/***************************************************************************
 *
 * COPYRIGHTHERE
 *
 * $Id: anypy.c,v 1.20.2.2 2003/01/03 11:22:25 sasa Exp $
 *
 * Author: Bazsi
 * Auditor: Bazsi
 * Last audited version: 1.14
 * Notes:
 *
 ***************************************************************************/
 
#include <zorp/zorp.h>
#include <zorp/proxy.h>
#include <zorp/thread.h>
#include <zorp/policy.h>
#include <zorp/zpython.h>
#include <zorp/pystream.h>
#include <zorp/registry.h>
#include <zorp/log.h>

typedef struct _ZAnyPyProxy
{
  ZProxy super;
} ZAnyPyProxy;

static gpointer
anypy_thread(gpointer s)
{
  ZAnyPyProxy *self = (ZAnyPyProxy *) s;
  ZPolicyObj *res;
  gboolean called;
  
  z_proxy_enter(self);

  ZPROXY_SET_STATE(self, PS_CONFIG);
  if (z_proxy_config_event(&self->super))
    {

      ZPROXY_SET_STATE(self, PS_STARTING_UP);
      if (z_proxy_startup_event(&self->super))
        {

          z_policy_lock(self->super.thread);  
          res = z_policy_call(self->super.handler, "proxyThread", NULL, &called, self->super.session_id);
          z_policy_var_unref(res);
          z_policy_unlock(self->super.thread);

        }
    }
    
  ZPROXY_SET_STATE(self, PS_SHUTTING_DOWN);
  z_proxy_shutdown_event(&self->super);
    
  z_proxy_destroy(&self->super);
  z_leave();
  return NULL;
}

ZProxy *
anypy_proxy_new(gchar *session_id,
		ZorpStream *client, 
                ZPolicyObj *handler)
{
  ZAnyPyProxy *self = g_new0(ZAnyPyProxy, 1);
  
  z_enter();
  z_proxy_init(&self->super, session_id, client->stream, handler);
  
  z_thread_new(session_id, anypy_thread, self);
  z_leave();
  return &self->super;
}

gint
zorp_module_init(void)
{
  z_registry_add("anypy", ZR_PYPROXY, anypy_proxy_new);
  return TRUE;
}
