/***************************************************************************
 *
 * COPYRIGHTHERE
 *
 * $Id: httpproto.c,v 1.8 2002/07/22 14:31:15 sasa Exp $
 *
 * Author: Balazs Scheidler <bazsi@balabit.hu>
 * Auditor: 
 * Last audited version: 
 * Notes:
 *   Based on the code by: Viktor Peter Kovacs <vps__@freemail.hu>
 *
 ***************************************************************************/

#include "http.h"

#include <string.h>

/* FIXME: put these into a hashtable */

//#define HTTP_REQ_TBLSIZE (11)
//#define HTTP_RESP_TBLSIZE (37)

typedef struct _HttpRequest
{
  char name[16];
  int val;
} HttpRequest;

typedef struct _HttpResponse
{
  char name[4];
  int val;
} HttpResponse;

static HttpRequest request_table[] = 
{
  {"HEAD", HTTP_REQ_FLG_HEAD},
  {"OPTIONS", HTTP_REQ_FLG_ASTERIX},
  {"CONNECT", HTTP_REQ_FLG_CONNECT},
};

static HttpResponse response_table[] = 
{
  {"100", HTTP_RESP_FLG_CONTINUE},			/* unused => hardcoded */
  {"101", HTTP_RESP_FLG_NODATA | HTTP_RESP_FLG_STOP},	/* update to protocol (similar to connect) */

  {"204", HTTP_RESP_FLG_NODATA},
  {"205", HTTP_RESP_FLG_NODATA},
  {"304", HTTP_RESP_FLG_NODATA},

  {"402", HTTP_RESP_FLG_STOP},
};

int
http_proto_request_lookup(char *req)
{
  guint x;
  
  for (x = 0; x < (sizeof(request_table) / sizeof(HttpRequest)); x++)
    {
      if (strcasecmp(req, request_table[x].name) == 0)
	return (request_table[x].val);
    }
  return 0;
}

int
http_proto_response_lookup(char *resp)
{
  guint x;
  for (x = 0; x < (sizeof(response_table) / sizeof(HttpResponse)); x++)
    {
      if (strcasecmp(resp, response_table[x].name) == 0)
	return (response_table[x].val);
    }
  return 0;
}
