############################################################################
##
## Copyright (c) 2000, 2001, 2002 BalaBit IT Ltd, Budapest, Hungary
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##
## $Id: Plug.py,v 1.24.2.7 2003/07/28 14:14:01 sasa Exp $
##
## Author  : Bazsi
## Auditor : kisza
## Last audited version: 1.10
## Notes:
##
############################################################################

"""Module defining an interface to the Plug proxy module.

This module defines an interface to the Plug proxy. Plug is a simple TCP
circuit, which means that transmission takes place without protocol
verification.
"""

from Zorp import *
from Proxy import Proxy

PLUG_DEBUG = "plug.debug"

class PlugProxy(Proxy):
	"""Class encapsulating the Plug proxy implemented in Zorp.
	
	This class implements a general plug proxy, with optionally
	disabling data transfer in either direction.

	By default plug copies all data in both directions. To change
	this set the 'copy_to_client' or 'copy_to_server' attributes
	to FALSE.

	Secondary sessions
	
	  Plug supports several sessions in the same proxy instance (e.g. in
	  the same thread), effectively reusing proxy instances. As new
	  sessions enter the proxy via a fastpath, using secondary sessions
	  might decrease firewall load significantly.
	  
	  When a new connection is accepted, Zorp looks for the appropriate
	  proxy instance which is willing to accept secondary sessions. If
	  there is none, a new proxy instance is started. An already running
	  proxy instance is appropriate if it is willing to accept secondary
	  channels and the criteria about secondary sessions set by the
	  administrator match.
	  
	  The critera in plug is set by the 'secondary_mask' attribute,
	  consult the attribute documentation for more details.

	  Note 
	
	    Copying out of band data is not supported.

	Attributes

	  copy_to_server              -- [BOOLEAN:TRUE:W:R] Copy data in
					 client->server direction
	  
	  copy_to_client              -- [BOOLEAN:TRUE:W:R] Copy data in
					 server->client direction
	  
	  bandwidth_to_client         -- [INTEGER:n/a:-:R] Readonly variable
					 containing the utilized bandwidth
					 in server->client direction.
				 
	  bandwidth_to_server         -- [INTEGER:n/a:-:R] Readonly variable
					 containing the utilized bandwidth
					 in client->server direction.
				 
	  packet_stats_interval_time  -- [INTEGER:0:W:R] The number of
					 milliseconds between two successive
					 packetStats() events.
					 Set to 0 to turn packetStats() off.

	  packet_stats_interval_packet -- [INTEGER:0:W:R] The number of
					 passing packages between two
					 successive packetStats() events.
					 Set to 0 to turn packetStats() off.
				   
	  stack_proxy                 -- [CLASS_proxy:n/a:-:-] the proxy class to
					 stack into the connection

	  timeout                     -- [INTEGER:600000:W:R] I/O timeout in
					 milisec.

	  shutdown_soft	              -- [BOOLEAN:FALSE:W:R] Set TRUE if
					 you want to shutdown each way (Read
					 and Write) separately.

          buffer_size                 -- [INTEGER:1500:W:R] The size of the
                                         buffer used for copying data.

	  secondary_sessions          -- [INTEGER:10:RW:R] The number of
					 possible secondary sessions within
					 a single plug instance.

	  secondary_mask	      -- [INTEGER:0xF:RW:R] an integer
					 specifying which properties of an
					 established session is marked
					 important.  If all important
					 properties match, a secondary
					 session is handled by this plug
					 proxy given the new session would
					 not exceed 'secondary_sessions'.
					 This is a bitfield with the
					 following interpretation: bit 0
					 means source address, bit 1 means
					 source port, bit 2 means
					 destination address, bit 3 means
					 destination port.

	"""
	name = "plug"
	def __init__(self, session):
		"""Constructor initializing a PlugProxy instance.

		This constructor creates and sets up a PlugProxy instance.

		Arguments

		  self -- this instance
		  
		  session -- session this instance belongs to
		
		"""
		self.stack_proxy = None
		Proxy.__init__(self, session)

	def requestStack(self):
		"""Function returning the stacked proxy class.
		
		This callback is called by the underlying C proxy to query
		if something is to be stacked into it. It should return
		the proxy class to be used.

		Arguments
		
		  self -- this instance
		  
		Returns
		
		  the class of the proxy to stack in
		"""
		return self.stack_proxy

	def packetStats(self, client_bytes, client_pkts, server_bytes, server_pkts):
		"""Function called when the packet_stats_interval is elapsed.

		This function is called whenever the time interval elapses
	        (or as currently implemented the given number of
	        packets were transmitted). this event receives packet
	        statistics as parameters.

	        It's useful for terminating connections with excessive
	        bandwidth requirements (for instance to limit the impact of
	        the covert channel opened when using plug instead of a
	        protocol specific proxy).
	        
	        Arguments
	        
	          self -- this instance
	          
	          client_bytes -- the number of bytes transmitted to the client
	          
	          client_pkts  -- the number of packets transmitted to the client
	          
	          server_bytes -- the number of bytes transmitted to the server
	          
	          server_pkts  -- the number of packets transmitted to the server
		"""
		raise NotImplementedError

	# This statement registers the default tracker class to use for
	# datagram oriented sessions. To change this assign a different
	# value to the conntrack attribute.
