from Zorp import Zorp, SockAddr, Listener, Zone, Service, Chainer, Stream, Plug, POP3, AnyPy, Ftp, Session, Receiver, Sink
from Zorp.LabelSet import LabelSet
import time

Zorp.zones = [Zone.InetZone("internet", "0.0.0.0", "0.0.0.0", None),
	      Zone.InetZone("balabit", "192.168.131.0", "255.255.255.0", None)]


class MyPlug(Plug.PlugProxy):

        class InnerPlug(Plug.PlugProxy):
                def startUp(self):
                        Zorp.debug(0, "innerplug startup")

        def config(self):
                Zorp.debug(0, "MyPlug config()")

                self.copy_to_server = 0
                self.copy_to_client = 0
                self.packet_stats_interval = 500
                
        def startUp(self):
                Zorp.debug(0, "MyPlug startUp()")
                
        def shutDown(self):
                Zorp.debug(0, "MyPlug shutDown()")
                
        def packetStats(self, client_bytes, client_pkt, server_bytes, server_pkt):
                Zorp.debug(0, "server->client: packet=%d, bytes=%d, bandwidth=%f" % (client_pkt, client_bytes, self.bandwidth_to_client))
                Zorp.debug(0, "client->server: packet=%d, bytes=%d, bandwidth=%f" % (server_pkt, server_bytes, self.bandwidth_to_server))
                return 1

def init(name):
	plug_service = Service.Service("plug", Chainer.DirectedChainer(None, SockAddr.SockAddrInet("192.168.131.5", 6969)), Plug.PlugProxy)
	Listener.Listen(SockAddr.SockAddrInet("192.168.131.1", 1976), plug_service)

Zorp.debug(0, "Policy bootstrap done...");
