/***************************************************************************
 *
 * Copyright (c) 2000, 2001, 2002, 2003, 2004 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation.
 *
 * Note that this permission is granted for only version 2 of the GPL.
 *
 * As an additional exemption you are allowed to compile & link against the
 * OpenSSL libraries as published by the OpenSSL project. See the file
 * COPYING for details.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: fastpath.h,v 1.5 2004/04/15 11:13:36 bazsi Exp $
 *
 ***************************************************************************/

#ifndef ZORP_FASTPATH_H_INCLUDED
#define ZORP_FASTPATH_H_INCLUDED

#include <zorp/zorp.h>
#include <zorp/sockaddr.h>
#include <zorp/stream.h>
#include <zorp/connection.h>

typedef struct _ZProxyFastpathSession
{
  ZSockAddr *client_address;
  ZSockAddr *client_local;
  ZSockAddr *server_address;
  ZSockAddr *server_local;
} ZProxyFastpathSession;

typedef struct _ZProxyFastpath
{
  gpointer router_data; 
  void (*router)(ZProxyFastpathSession *conn, gpointer data);
  void (*router_free)(gpointer data);

  gpointer chainer_data;
  ZStream *(*chainer)(ZProxyFastpathSession *conn, gpointer data);
  void (*chainer_free)(gpointer data);

  gpointer snat_data;
  void (*snat)(ZProxyFastpathSession *conn, gpointer data);
  void (*snat_free)(gpointer data);

  gpointer dnat_data;
  void (*dnat)(ZProxyFastpathSession *conn, gpointer data);  
  void (*dnat_free)(gpointer data);
} ZProxyFastpath;


void z_proxy_fastpath_session_destroy(ZProxyFastpathSession *self);
void z_proxy_fastpath_destroy(ZProxyFastpath *self);

struct _ZProxy;

ZStream *
z_proxy_fastpath_connect_server(struct _ZProxy *proxy, ZConnection *conn);


#endif
