/***************************************************************************
 *
 * Copyright (c) 2000, 2001, 2002, 2003, 2004 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation.
 *
 * Note that this permission is granted for only version 2 of the GPL.
 *
 * As an additional exemption you are allowed to compile & link against the
 * OpenSSL libraries as published by the OpenSSL project. See the file
 * COPYING for details.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: proxyvars.h,v 1.5 2003/10/10 09:37:36 bazsi Exp $
 *
 ***************************************************************************/

#ifndef ZORP_PYVARS_H_INCLUDED
#define ZORP_PYVARS_H_INCLUDED

#include <zorp/zorp.h>
#include <zorp/policy.h>

struct _ZProxy;

#define Z_VAR_GET		0x00000001	/* variable can be read */
#define Z_VAR_SET		0x00000003	/* variable can be read and written */
#define Z_VAR_GET_CONFIG	0x00000004	
#define Z_VAR_SET_CONFIG	0x0000000C	/* variable can be read and written */
#define Z_VAR_GET_VERBOSE	0x00000010
#define Z_VAR_SET_VERBOSE	0x00000020

#define Z_VAR_TYPE(t) ((t) & 0x0000ff00)

#define Z_VAR_TYPE_INT		0x00000100	/* variable is an int */
#define Z_VAR_TYPE_STRING	0x00000200	/* variable is a string */
#define Z_VAR_TYPE_SOCKADDR	0x00000300	/* variable is a sockaddr */
#define Z_VAR_TYPE_OBJECT       0x00000400	/* variable is a policy object */
#define Z_VAR_TYPE_HASH		0x00000500	/* variable is a hash */
#define Z_VAR_TYPE_METHOD	0x00000600      /* variable is a method */
#define Z_VAR_TYPE_CUSTOM	0x00000700	/* variable is something, requests are 
                                                   processed via a function call */
#define Z_VAR_TYPE_DIMHASH	0x00000800      /* variable is a multidimensional hash */
#define Z_VAR_TYPE_ALIAS	0x00000900	/* variable is an alias of another variable */
#define Z_VAR_TYPE_OBSOLETE	0x00000A00      /* variable is an obsolete alias of another variable */

typedef gint (*ZProxySetVarFunc)(struct _ZProxy *self, gchar *name, gpointer value, ZPolicyObj *newvalue);
typedef ZPolicyObj *(*ZProxyGetVarFunc)(struct _ZProxy *self, gchar *name, gpointer value);

typedef ZPolicyObj *(*ZProxyMethodFunc)(struct _ZProxy *self, ZPolicyObj *args);

typedef struct _ZProxyVars 
{
  GHashTable *vars;
  struct _ZSessionVars *session_vars;
} ZProxyVars;

typedef struct _ZSessionVars
{
  GHashTable *vars;
} ZSessionVars;

gint z_proxy_vars_setattr(struct _ZProxy *self, gchar *name, ZPolicyObj *new);
ZPolicyObj *z_proxy_vars_getattr(struct _ZProxy *self, gchar *name);

ZProxyVars *z_proxy_vars_new(void);
void z_proxy_vars_destroy(ZProxyVars *vars);
void z_proxy_vars_dump_values(ZProxyVars *vars, struct _ZProxy *proxy);
void z_proxy_vars_set_session(ZProxyVars *vars, ZSessionVars *session);
void z_proxy_vars_var_new(GHashTable *hash, gchar *name, guint flags, ...);
void z_proxy_vars_set_active_session(struct _ZProxy *self, struct _ZSessionVars *vars);

ZSessionVars *z_session_vars_new(void);
void z_session_vars_destroy(ZSessionVars *self);

#endif
