############################################################################
##
##  COPYRIGHTHERE
##
## $Id: Finger.py,v 1.19 2004/06/15 12:28:47 sasa Exp $
##
## Author  : Bazsi
## Auditor : 
## Last audited version:
## Notes:
##
############################################################################

"""Module defining interface to the Finger proxy.

This module defines the interface to the Finger proxy as implemented by
the Finger Zorp module.
"""

from Zorp import *
from Proxy import Proxy

class AbstractFingerProxy(Proxy):
	"""Wrapper class for the Finger protocol proxy implemented by Zorp.
	
	This proxy implements the finger protocol as specified in rfc1288.
	
	Usage
	
	  You can limit username length and response length by setting
	  various attributes. Finger proxy also has the capability
	  of limiting the number of hosts in a request, like:
	  
	    finger bazsi@balabit@tudor
	    
	  which normally results in fingering bazsi@balabit performed by
	  the host tudor. By default this proxy strips off everything
	  after and including the first '@' character, you can change
	  this behaviour by setting max_hop_count to a nonzero value.
	  
	Attributes
	
	  max_hop_count               -- [INTEGER:0:RW:R] the maximum number
					 of '@' characters in the request
	  
	  max_hostname_length         -- [INTEGER:30:RW:R] the maximum number
					 of characters in a single name from
					 hostname chain

	  max_line_length             -- [INTEGER:132:RW:R] the maximum 
					 number of characters in a single line
					 on both side.

	  max_username_length         -- [INTEGER:8:RW:R] the maximum length
					 of the username part in the request

	  request_detailed            -- [INTEGER:n/a:-:RW] indicates that
					 the request was prefixed with /W
					 requesting long response (the -l
					 parameter to the finger client) can
					 be changed during the fingerRequest
					 event

	  request_hostnames           -- [STRING:n/a:-:RW] contains the
					 hostname chain. (can be changed
					 during fingerRequest)

	  request_username            -- [STRING:n/a:-:RW] contains the
					 username (can be changed during
					 fingerRequest)
 
	  response_header             -- [STRING:"":RW:RW] prepend this 
					 string to each finger response
	  
	  response_footer             -- [STRING:"":RW:RW] append this string
					 to each finger response
	  
	  strict_username_check       -- [BOOLEAN:TRUE:RW:R] if enabled usernames are
					 checked strictly [a-zA-Z0-9_]
	  
	  timeout                     -- [INTEGER:30000:RW:R] I/O timeout in
					 millisec.
	  
	"""
	name = "finger"

	def __init__(self, session):
		"""Constructor to initialize a FingerProxy instance.

		This constructor creates and set up a FingerProxy instance.

		Arguments

		  self -- this instance
		  
		  session -- session this instance belongs to
		
		"""
		Proxy.__init__(self, session)

	def fingerRequest(self, username, hostname):
		"""Function to process a given finger request.
		
		This function is called by the finger proxy to process a 
		request. It has a chance to change request specific
		attributes.
		
		Arguments
		
		  self -- this instance
		  
		  username -- the username to be fingered
		  
		  hostname -- The hosts where finger will go trough.
		"""
		return Z_ACCEPT

	def config(self):
		pass

class FingerProxy(AbstractFingerProxy):
	pass
