############################################################################
##
## Copyright (c) 2000, 2001, 2002 BalaBit IT Ltd, Budapest, Hungary
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##
## $Id: Whois.py,v 1.10 2004/06/15 12:28:48 sasa Exp $
##
## Author  : Bazsi
## Auditor :
## Last audited version: 1.1
## Notes:
##
############################################################################

"""Module defining interface to the Whois proxy.

This module defines the interface to the Whois proxy as implemented by
the Whois Zorp module.
"""

from Zorp import *
from Proxy import Proxy

class AbstractWhoisProxy(Proxy):
	"""Wrapper class for the WHOIS protocol proxy implemented by Zorp.
	
	This class implements the WHOIS protocol as specified by RFC954.
	
	Attributes
	
	  timeout                     -- [INTEGER:30000:RW:R] I/O timeout in
					 milliseconds.
	  
	  max_line_length             -- [INTEGER:132:RW:R] the maximum number
					 of characters in a single line

	  max_request_length          -- [INTEGER:128:RW:R] Max length of a
					 whois request.

	  request                     -- [STRING:"":-:RW] The whois request
					 line.

	  response_header             -- [STRING:"":RW:RW] prepend this string
					 to each whois response
	  
	  response_footer             -- [STRING:"":RW:RW] append this string
					 to each whois response
	  
	"""
	name = "whois"

	def __init__(self, session):
		"""Constructor to initialize a WhoisProxy instance.

		This constructor creates and set up a WhoisProxy instance.

		Arguments

		  self -- this instance
		  
		  session -- session this instance belongs to
		
		"""
		Proxy.__init__(self, session)

	def whoisRequest(self, request):
		"""Function to process a given whois request.
		
		This function is called by the whois proxy to process a 
		request. It has a chance to change request specific
		attributes.
		
		Arguments
		
		  self -- this instance
		  
		  request -- request contents, same as self.request
		"""
		return Z_ACCEPT

class WhoisProxy(AbstractWhoisProxy):
	pass
