############################################################################
##
## Copyright (c) 2000, 2001, 2002 BalaBit IT Ltd, Budapest, Hungary
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##
## $Id: Attach.py,v 1.2 2003/10/02 13:53:34 bazsi Exp $
##
## Author  : Bazsi
## Auditor : kisza
## Last audited version: 1.7
## Notes:
##
############################################################################

"""Implements classes to establish a connection.

This module implements a Python wrapper around the ZorpAttach class
implemented in C.
"""

import Zorp

class Attacher:
	"""A wrapper class around the ZorpAttach class implemented in C.

	This class is a wrapper around the ZorpAttach class
	implemented by the Zorp core, and as such it'll be a placeholder
	for future extensions.
	   
	Attributes
	
	  local	  -- Address of local end of the connection (set after 
	             __init__ in nonblocking mode, or after blockingConnect() 
	             in blocking mode)
	  
	  remote  -- Address where we connect
	  
	  attach -- a Zorp.Attach object
	"""

	def __init__(self, session_id, protocol, local, remote, callback = None, **kw):
		"""Constructor initializing a Attach instance.
		
		Sets the instance attributes based on constructor
		parameters, and starts connecting in a separate thread if
		callback is not None. If callback is None, a separate call
		to blockingConnect() will start the connection.

		Arguments

		  self     -- this instance
		  
		  local    -- Address of local end of the connection
		  
		  remote   -- Address where we connect
		  
		  callback -- Callback to be called when the connection is
		              established. 

		  local_loose -- allocate local port loosely, that is allow
				and resolve port clashes and substitute
				clashing ports with another port in the same
				range
		"""
		
		self.local = local
		self.remote = remote
		self.attach = Zorp.Attach(session_id, protocol, local, remote, callback, kw)

	def block(self):
		"""Function establishing a connection in blocking mode.
		
		This function must be called when the Connect instance was
		initialized with callback=None. It establishes the connection
		in this thread (ie. waits for the connection to complete)
		and returns the file corresponding file descriptor.
		
		Arguments
		
		  self  -- this instance
		  
		Returns
		
		  the stream corresponding to the connection
		"""
		global connect_hook
		
		self.attach.start()
		self.local = self.attach.local
		return self.attach.block()

	def start(self):
		self.attach.start()
		
	def cancel(self):
		"""Function to destroy this connector instance.
		
		This function forces the underlying ZorpAttach instance
		to stop connecting and free any allocated memory block.
		   
		Arguments
		
		  self -- instance
		"""
		self.attach.cancel()
