/**********************************************************************
zyGrib: meteorological GRIB file viewer
Copyright (C) 2008-2010 - Jacques Zaninetti - http://www.zygrib.org

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
***********************************************************************/

#ifndef MBLUEREADER_H
#define MBLUEREADER_H

#include <iostream>
#include <cmath>
#include <cassert>
#include <vector>

#include "IrregularGridded.h"
#include "zuFile.h"
#include "MblueRecord.h"


//===============================================================
class MblueReader : public IrregularGridReader
{
    public:
        MblueReader (const std::string fname);
        virtual ~MblueReader() {}
		
		virtual FileDataType getReaderFileDataType () 
					{return DATATYPE_MBLUE;};
		
		MblueRecord * getMblueRecord (time_t date);
		virtual GriddedRecord *getFirstRecord ();
		
		virtual GriddedRecord *getRecord (DataCode dtc, time_t date);
		
		// Rectangle de la zone couverte par les données
        virtual bool getZoneExtension (
					 double *x0,double *y0, double *x1,double *y1);

        virtual double  getDateInterpolatedValue (
					 DataCode dtc,  double px, double py, time_t date);

		virtual bool hasAltitudeData ()  {return false;}
		
	protected:
		virtual void  openFile (const std::string fname);
		
		std::list<MblueRecord  *> listRecords;


};


#endif
